/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaBoundary;
import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.Terminal;
import java.util.Objects;
import java.util.Optional;

public class AreaBoundaryImpl
implements AreaBoundary {
    private final Area area;
    private Terminal terminal;
    private final Boundary boundary;
    private final boolean ac;

    AreaBoundaryImpl(Area area, Terminal terminal, boolean ac) {
        this.area = Objects.requireNonNull(area);
        this.terminal = Objects.requireNonNull(terminal);
        this.boundary = null;
        this.ac = ac;
    }

    AreaBoundaryImpl(Area area, Boundary boundary, boolean ac) {
        this.area = Objects.requireNonNull(area);
        this.boundary = Objects.requireNonNull(boundary);
        this.terminal = null;
        this.ac = ac;
    }

    public Area getArea() {
        return this.area;
    }

    public Optional<Terminal> getTerminal() {
        return Optional.ofNullable(this.terminal);
    }

    public Optional<Boundary> getBoundary() {
        return Optional.ofNullable(this.boundary);
    }

    public boolean isAc() {
        return this.ac;
    }

    public double getP() {
        return this.boundary != null ? this.boundary.getP() : this.terminal.getP();
    }

    public double getQ() {
        return this.boundary != null ? this.boundary.getQ() : this.terminal.getQ();
    }

    void replaceTerminal(Terminal oldTerminal, Terminal newTerminal) {
        Objects.requireNonNull(oldTerminal);
        Objects.requireNonNull(newTerminal);
        if (this.terminal == oldTerminal) {
            this.terminal = newTerminal;
        }
    }
}

