/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.impl.NodeBreakerTopologyModel;
import com.powsybl.iidm.network.impl.SwitchImpl;
import com.powsybl.iidm.network.impl.VoltageLevelImpl;
import com.powsybl.iidm.network.util.NetworkReports;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;

public final class ConnectDisconnectUtil {
    private ConnectDisconnectUtil() {
    }

    static boolean connectAllTerminals(Identifiable<?> identifiable, List<? extends Terminal> terminals, Predicate<Switch> isTypeSwitchToOperate, ReportNode reportNode) {
        boolean isAlreadyConnected = true;
        boolean isNowConnected = true;
        HashSet<SwitchImpl> switchForDisconnection = new HashSet<SwitchImpl>();
        for (Terminal terminal : terminals) {
            if (terminal.isConnected()) {
                NetworkReports.alreadyConnectedIdentifiableTerminal((ReportNode)reportNode, (String)identifiable.getId());
                continue;
            }
            isAlreadyConnected = false;
            if (terminal.getVoltageLevel().getTopologyKind() == TopologyKind.NODE_BREAKER) {
                NodeBreakerTopologyModel topologyModel = (NodeBreakerTopologyModel)((VoltageLevelImpl)terminal.getVoltageLevel()).getTopologyModel();
                isNowConnected = topologyModel.getConnectingSwitches(terminal, isTypeSwitchToOperate, switchForDisconnection);
            }
            if (isNowConnected) continue;
            return false;
        }
        if (isAlreadyConnected) {
            return false;
        }
        for (Terminal terminal : terminals) {
            if (terminal.isConnected() || terminal.getVoltageLevel().getTopologyKind() != TopologyKind.BUS_BREAKER) continue;
            isNowConnected = isNowConnected && terminal.connect(isTypeSwitchToOperate);
        }
        switchForDisconnection.forEach(sw -> sw.setOpen(false));
        return isNowConnected;
    }

    static boolean disconnectAllTerminals(Identifiable<?> identifiable, List<? extends Terminal> terminals, Predicate<Switch> isSwitchOpenable, ReportNode reportNode) {
        boolean isAlreadyDisconnected = true;
        boolean isNowDisconnected = true;
        HashSet<SwitchImpl> switchForDisconnection = new HashSet<SwitchImpl>();
        for (Terminal terminal : terminals) {
            NodeBreakerTopologyModel topologyModel;
            if (!terminal.isConnected()) {
                NetworkReports.alreadyDisconnectedIdentifiableTerminal((ReportNode)reportNode, (String)identifiable.getId());
                continue;
            }
            isAlreadyDisconnected = false;
            if (terminal.getVoltageLevel().getTopologyKind() != TopologyKind.NODE_BREAKER || (topologyModel = (NodeBreakerTopologyModel)((VoltageLevelImpl)terminal.getVoltageLevel()).getTopologyModel()).getDisconnectingSwitches(terminal, isSwitchOpenable, switchForDisconnection)) continue;
            return false;
        }
        if (isAlreadyDisconnected) {
            return false;
        }
        for (Terminal terminal : terminals) {
            if (!terminal.isConnected() || terminal.getVoltageLevel().getTopologyKind() != TopologyKind.BUS_BREAKER) continue;
            isNowDisconnected = isNowDisconnected && terminal.disconnect(isSwitchOpenable);
        }
        switchForDisconnection.forEach(sw -> sw.setOpen(true));
        return isNowDisconnected;
    }
}

