/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.DanglingLineAdderImpl;
import com.powsybl.iidm.network.impl.DanglingLineImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;

class GenerationAdderImpl
implements DanglingLineAdder.GenerationAdder {
    private final DanglingLineAdderImpl parent;
    private double minP = Double.NaN;
    private double maxP = Double.NaN;
    private double targetP = Double.NaN;
    private double targetQ = Double.NaN;
    private boolean voltageRegulationOn = false;
    private double targetV = Double.NaN;

    GenerationAdderImpl(DanglingLineAdderImpl parent) {
        this.parent = parent;
    }

    public GenerationAdderImpl setTargetP(double targetP) {
        this.targetP = targetP;
        return this;
    }

    public GenerationAdderImpl setMaxP(double maxP) {
        this.maxP = maxP;
        return this;
    }

    public GenerationAdderImpl setMinP(double minP) {
        this.minP = minP;
        return this;
    }

    public GenerationAdderImpl setTargetQ(double targetQ) {
        this.targetQ = targetQ;
        return this;
    }

    public GenerationAdderImpl setVoltageRegulationOn(boolean voltageRegulationOn) {
        this.voltageRegulationOn = voltageRegulationOn;
        return this;
    }

    public GenerationAdderImpl setTargetV(double targetV) {
        this.targetV = targetV;
        return this;
    }

    public DanglingLineAdderImpl add() {
        NetworkImpl network = this.parent.getNetwork();
        ValidationUtil.checkActivePowerLimits((Validable)this.parent, (double)this.minP, (double)this.maxP);
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkActivePowerSetpoint((Validable)this.parent, (double)this.targetP, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkVoltageControl((Validable)this.parent, (Boolean)this.voltageRegulationOn, (double)this.targetV, (double)this.targetQ, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        this.parent.setGenerationAdder(this);
        return this.parent;
    }

    DanglingLineImpl.GenerationImpl build() {
        return new DanglingLineImpl.GenerationImpl(this.parent.getNetwork(), this.minP, this.maxP, this.targetP, this.targetQ, this.targetV, this.voltageRegulationOn);
    }
}

