/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadModel;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.Optional;

class LoadImpl
extends AbstractConnectable<Load>
implements Load {
    private final Ref<? extends VariantManagerHolder> network;
    private LoadType loadType;
    private LoadModel model;
    private final TDoubleArrayList p0;
    private final TDoubleArrayList q0;

    LoadImpl(Ref<NetworkImpl> networkRef, String id, String name, boolean fictitious, LoadType loadType, LoadModel model, double p0, double q0) {
        super(networkRef, id, name, fictitious);
        this.network = networkRef;
        this.loadType = loadType;
        this.model = model;
        int variantArraySize = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantArraySize();
        this.p0 = new TDoubleArrayList(variantArraySize);
        this.q0 = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.p0.add(p0);
            this.q0.add(q0);
        }
    }

    public TerminalExt getTerminal() {
        return (TerminalExt)this.terminals.get(0);
    }

    @Override
    protected String getTypeDescription() {
        return "Load";
    }

    public LoadType getLoadType() {
        return this.loadType;
    }

    public Load setLoadType(LoadType loadType) {
        ValidationUtil.checkLoadType((Validable)this, (LoadType)loadType);
        LoadType oldValue = this.loadType;
        this.loadType = loadType;
        this.notifyUpdate("loadType", (Object)oldValue.toString(), (Object)loadType.toString());
        return this;
    }

    public double getP0() {
        return this.p0.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public LoadImpl setP0(double p0) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkP0((Validable)this, (double)p0, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        double oldValue = this.p0.set(variantIndex, p0);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("p0", variantId, (Object)oldValue, (Object)p0);
        return this;
    }

    public double getQ0() {
        return this.q0.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public LoadImpl setQ0(double q0) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkQ0((Validable)this, (double)q0, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        double oldValue = this.q0.set(variantIndex, q0);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("q0", variantId, (Object)oldValue, (Object)q0);
        return this;
    }

    public Optional<LoadModel> getModel() {
        return Optional.ofNullable(this.model);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.p0.ensureCapacity(this.p0.size() + number);
        this.q0.ensureCapacity(this.q0.size() + number);
        for (int i = 0; i < number; ++i) {
            this.p0.add(this.p0.get(sourceIndex));
            this.q0.add(this.q0.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.p0.remove(this.p0.size() - number, number);
        this.q0.remove(this.q0.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.p0.set(index, this.p0.get(sourceIndex));
            this.q0.set(index, this.q0.get(sourceIndex));
        }
    }
}

