/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractTapChangerAdderImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerParent;
import com.powsybl.iidm.network.impl.RatioTapChangerStepImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import java.util.List;

class RatioTapChangerAdderImpl
extends AbstractTapChangerAdderImpl<RatioTapChangerAdderImpl, RatioTapChangerParent, RatioTapChanger, RatioTapChangerStepImpl>
implements RatioTapChangerAdder {
    private boolean loadTapChangingCapabilities = false;
    private RatioTapChanger.RegulationMode regulationMode = null;

    RatioTapChangerAdderImpl(RatioTapChangerParent parent) {
        super(parent);
    }

    public RatioTapChangerAdder setLoadTapChangingCapabilities(boolean loadTapChangingCapabilities) {
        this.loadTapChangingCapabilities = loadTapChangingCapabilities;
        return this;
    }

    public RatioTapChangerAdder setTargetV(double targetV) {
        if (!Double.isNaN(targetV)) {
            this.regulationMode = RatioTapChanger.RegulationMode.VOLTAGE;
        }
        return (RatioTapChangerAdder)this.setRegulationValue(targetV);
    }

    public RatioTapChangerAdder setRegulationMode(RatioTapChanger.RegulationMode regulationMode) {
        this.regulationMode = regulationMode;
        return this;
    }

    public RatioTapChangerAdder.StepAdder beginStep() {
        return new StepAdderImpl();
    }

    @Override
    protected RatioTapChanger createTapChanger(RatioTapChangerParent parent, int lowTapPosition, List<RatioTapChangerStepImpl> steps, TerminalExt regulationTerminal, Integer tapPosition, boolean regulating, double regulationValue, double targetDeadband) {
        RatioTapChangerImpl tapChanger = new RatioTapChangerImpl(parent, lowTapPosition, steps, regulationTerminal, this.loadTapChangingCapabilities, tapPosition, regulating, this.regulationMode, regulationValue, targetDeadband);
        parent.setRatioTapChanger(tapChanger);
        return tapChanger;
    }

    @Override
    protected RatioTapChangerAdderImpl self() {
        return this;
    }

    @Override
    protected ValidationLevel checkTapChangerRegulation(RatioTapChangerParent parent, double regulationValue, boolean regulating, TerminalExt regulationTerminal) {
        return ValidationUtil.checkRatioTapChangerRegulation((Validable)parent, (boolean)regulating, (boolean)this.loadTapChangingCapabilities, (Terminal)regulationTerminal, (RatioTapChanger.RegulationMode)this.regulationMode, (double)regulationValue, (Network)this.getNetwork(), (ValidationLevel)this.getNetwork().getMinValidationLevel(), (ReportNode)this.getNetwork().getReportNodeContext().getReportNode());
    }

    @Override
    protected String getValidableType() {
        return "ratio tap changer";
    }

    class StepAdderImpl
    implements RatioTapChangerAdder.StepAdder {
        private double rho = Double.NaN;
        private double r = 0.0;
        private double x = 0.0;
        private double g = 0.0;
        private double b = 0.0;

        StepAdderImpl() {
        }

        public RatioTapChangerAdder.StepAdder setRho(double rho) {
            this.rho = rho;
            return this;
        }

        public RatioTapChangerAdder.StepAdder setR(double r) {
            this.r = r;
            return this;
        }

        public RatioTapChangerAdder.StepAdder setX(double x) {
            this.x = x;
            return this;
        }

        public RatioTapChangerAdder.StepAdder setG(double g) {
            this.g = g;
            return this;
        }

        public RatioTapChangerAdder.StepAdder setB(double b) {
            this.b = b;
            return this;
        }

        public RatioTapChangerAdder endStep() {
            RatioTapChangerStepImpl step = new RatioTapChangerStepImpl(RatioTapChangerAdderImpl.this.steps.size(), this.rho, this.r, this.x, this.g, this.b);
            step.validate(RatioTapChangerAdderImpl.this.parent);
            RatioTapChangerAdderImpl.this.steps.add(step);
            return RatioTapChangerAdderImpl.this;
        }
    }
}

