/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorModel;
import com.powsybl.iidm.network.ShuntCompensatorModelType;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.ShuntCompensatorModelExt;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Objects;
import java.util.OptionalInt;

class ShuntCompensatorImpl
extends AbstractConnectable<ShuntCompensator>
implements ShuntCompensator {
    private static final String SHUNT_COMPENSATOR = "shunt compensator";
    private final Ref<? extends VariantManagerHolder> network;
    private final ShuntCompensatorModelExt model;
    private final RegulatingPoint regulatingPoint;
    private final ArrayList<Integer> sectionCount;
    private final TDoubleArrayList targetV;
    private final TDoubleArrayList targetDeadband;

    ShuntCompensatorImpl(Ref<NetworkImpl> network, String id, String name, boolean fictitious, ShuntCompensatorModelExt model, Integer sectionCount, TerminalExt regulatingTerminal, Boolean voltageRegulatorOn, double targetV, double targetDeadband) {
        super(network, id, name, fictitious);
        this.network = network;
        int variantArraySize = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantArraySize();
        this.regulatingPoint = new RegulatingPoint(id, this::getTerminal, variantArraySize, voltageRegulatorOn, true);
        this.regulatingPoint.setRegulatingTerminal(regulatingTerminal);
        this.sectionCount = new ArrayList(variantArraySize);
        this.targetV = new TDoubleArrayList(variantArraySize);
        this.targetDeadband = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.sectionCount.add(sectionCount);
            this.targetV.add(targetV);
            this.targetDeadband.add(targetDeadband);
        }
        this.model = Objects.requireNonNull(model).attach(this);
    }

    public TerminalExt getTerminal() {
        return (TerminalExt)this.terminals.get(0);
    }

    public int getSectionCount() {
        Integer section = this.sectionCount.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
        if (section == null) {
            throw ValidationUtil.createUndefinedValueGetterException();
        }
        return section;
    }

    public OptionalInt findSectionCount() {
        Integer section = this.sectionCount.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
        return section == null ? OptionalInt.empty() : OptionalInt.of(section);
    }

    public int getMaximumSectionCount() {
        return this.model.getMaximumSectionCount();
    }

    public ShuntCompensatorImpl setSectionCount(int sectionCount) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkSections((Validable)this, (Integer)sectionCount, (int)this.model.getMaximumSectionCount(), (ValidationLevel)this.getNetwork().getMinValidationLevel(), (ReportNode)this.getNetwork().getReportNodeContext().getReportNode());
        if (sectionCount < 0 || sectionCount > this.model.getMaximumSectionCount()) {
            throw new ValidationException((Validable)this, "unexpected section number (" + sectionCount + "): no existing associated section");
        }
        int variantIndex = n.getVariantIndex();
        Integer oldValue = this.sectionCount.set(variantIndex, sectionCount);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("sectionCount", variantId, (Object)oldValue, (Object)sectionCount);
        return this;
    }

    public ShuntCompensator unsetSectionCount() {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.throwExceptionOrLogError((Validable)this, (String)"count of sections in service has been unset", (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        Integer oldValue = this.sectionCount.set(variantIndex, null);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("sectionCount", variantId, (Object)oldValue, null);
        return this;
    }

    public double getB() {
        return this.model.getB(this.sectionCount.get(((VariantManagerHolder)this.network.get()).getVariantIndex()));
    }

    public double getG() {
        return this.model.getG(this.sectionCount.get(((VariantManagerHolder)this.network.get()).getVariantIndex()));
    }

    public double getB(int sectionCount) {
        return this.model.getB(sectionCount);
    }

    public double getG(int sectionCount) {
        return this.model.getG(sectionCount);
    }

    public ShuntCompensatorModelType getModelType() {
        return this.model.getType();
    }

    public ShuntCompensatorModel getModel() {
        return this.model;
    }

    public <M extends ShuntCompensatorModel> M getModel(Class<M> modelType) {
        if (modelType == null) {
            throw new IllegalArgumentException("shunt compensator model type is null");
        }
        if (modelType.isInstance(this.model)) {
            return (M)((ShuntCompensatorModel)modelType.cast(this.model));
        }
        throw new ValidationException((Validable)this, "incorrect shunt compensator model type " + modelType.getName() + ", expected " + this.model.getClass());
    }

    public TerminalExt getRegulatingTerminal() {
        return this.regulatingPoint.getRegulatingTerminal();
    }

    public ShuntCompensatorImpl setRegulatingTerminal(Terminal regulatingTerminal) {
        ValidationUtil.checkRegulatingTerminal((Validable)this, (Terminal)regulatingTerminal, (Network)this.getNetwork());
        TerminalExt oldValue = this.regulatingPoint.getRegulatingTerminal();
        this.regulatingPoint.setRegulatingTerminal((TerminalExt)regulatingTerminal);
        this.notifyUpdate("regulatingTerminal", (Object)oldValue, (Object)this.regulatingPoint.getRegulatingTerminal());
        return this;
    }

    public boolean isVoltageRegulatorOn() {
        return this.regulatingPoint.isRegulating(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public ShuntCompensatorImpl setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (boolean)voltageRegulatorOn, (double)this.targetV.get(variantIndex), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        ValidationUtil.checkTargetDeadband((Validable)this, (String)SHUNT_COMPENSATOR, (boolean)voltageRegulatorOn, (double)this.targetDeadband.get(variantIndex), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        boolean oldValue = this.regulatingPoint.setRegulating(variantIndex, voltageRegulatorOn);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("voltageRegulatorOn", variantId, (Object)oldValue, (Object)voltageRegulatorOn);
        return this;
    }

    public double getTargetV() {
        return this.targetV.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public ShuntCompensatorImpl setTargetV(double targetV) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        ValidationUtil.checkVoltageControl((Validable)this, (boolean)this.regulatingPoint.isRegulating(variantIndex), (double)targetV, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        double oldValue = this.targetV.set(variantIndex, targetV);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("targetV", variantId, (Object)oldValue, (Object)targetV);
        return this;
    }

    public double getTargetDeadband() {
        return this.targetDeadband.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public ShuntCompensatorImpl setTargetDeadband(double targetDeadband) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        ValidationUtil.checkTargetDeadband((Validable)this, (String)SHUNT_COMPENSATOR, (boolean)this.regulatingPoint.isRegulating(variantIndex), (double)targetDeadband, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        double oldValue = this.targetDeadband.set(variantIndex, targetDeadband);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("targetDeadband", variantId, (Object)oldValue, (Object)targetDeadband);
        return this;
    }

    @Override
    public void remove() {
        this.regulatingPoint.remove();
        super.remove();
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.sectionCount.ensureCapacity(this.sectionCount.size() + number);
        this.targetV.ensureCapacity(this.targetV.size() + number);
        this.targetDeadband.ensureCapacity(this.targetDeadband.size() + number);
        for (int i = 0; i < number; ++i) {
            this.sectionCount.add(this.sectionCount.get(sourceIndex));
            this.targetV.add(this.targetV.get(sourceIndex));
            this.targetDeadband.add(this.targetDeadband.get(sourceIndex));
        }
        this.regulatingPoint.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        ArrayList<Integer> tmpInt = new ArrayList<Integer>(this.sectionCount.subList(0, this.sectionCount.size() - number));
        this.sectionCount.clear();
        this.sectionCount.addAll(tmpInt);
        this.targetV.remove(this.targetV.size() - number, number);
        this.targetDeadband.remove(this.targetDeadband.size() - number, number);
        this.regulatingPoint.reduceVariantArraySize(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        this.regulatingPoint.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.sectionCount.set(index, this.sectionCount.get(sourceIndex));
            this.targetV.set(index, this.targetV.get(sourceIndex));
            this.targetDeadband.set(index, this.targetDeadband.get(sourceIndex));
        }
        this.regulatingPoint.allocateVariantArrayElement(indexes, sourceIndex);
    }

    @Override
    protected String getTypeDescription() {
        return "Shunt compensator";
    }
}

