/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.impl.Variant;
import com.powsybl.iidm.network.impl.VariantFactory;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.VariantManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class VariantArray<S extends Variant> {
    private final Ref<? extends VariantManagerHolder> variantManagerHolder;
    private final List<S> variants;

    VariantArray(Ref<? extends VariantManagerHolder> variantManagerHolder, VariantFactory<S> variantFactory) {
        this.variantManagerHolder = variantManagerHolder;
        VariantManagerImpl variantManager = ((VariantManagerHolder)variantManagerHolder.get()).getVariantManager();
        this.variants = Collections.synchronizedList(new ArrayList(variantManager.getVariantArraySize()));
        for (int i = 0; i < variantManager.getVariantArraySize(); ++i) {
            this.variants.add(null);
        }
        for (int i : variantManager.getVariantIndexes()) {
            this.variants.set(i, variantFactory.newVariant());
        }
    }

    S get() {
        return (S)((Variant)this.variants.get(((VariantManagerHolder)this.variantManagerHolder.get()).getVariantManager().getVariantContext().getVariantIndex()));
    }

    void push(int number, VariantFactory<S> variantFactory) {
        for (int i = 0; i < number; ++i) {
            this.variants.add(variantFactory.newVariant());
        }
    }

    void push(VariantFactory<S> variantFactory) {
        this.variants.add(variantFactory.newVariant());
    }

    void pop(int number) {
        for (int i = 0; i < number; ++i) {
            this.variants.remove(this.variants.size() - 1);
        }
    }

    void delete(int index) {
        this.variants.set(index, null);
    }

    void allocate(int[] indexes, VariantFactory<S> variantFactory) {
        for (int index : indexes) {
            this.variants.set(index, variantFactory.newVariant());
        }
    }

    S copy(int index) {
        return ((Variant)this.variants.get(index)).copy();
    }
}

