/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBiMap;
import com.google.common.primitives.Ints;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.VariantManager;
import com.powsybl.iidm.network.impl.MultiVariantContext;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.NetworkIndex;
import com.powsybl.iidm.network.impl.ThreadLocalMultiVariantContext;
import com.powsybl.iidm.network.impl.VariantContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariantManagerImpl
implements VariantManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariantManagerImpl.class);
    private static final int INITIAL_VARIANT_INDEX = 0;
    private VariantContext variantContext;
    private final NetworkIndex networkIndex;
    private final BiMap<String, Integer> id2index = HashBiMap.create();
    private int variantArraySize;
    private final Deque<Integer> unusedIndexes = new ArrayDeque<Integer>();
    private final NetworkImpl network;

    VariantManagerImpl(NetworkImpl network) {
        this.network = network;
        this.variantContext = new MultiVariantContext(0);
        this.networkIndex = network.getIndex();
        this.id2index.put((Object)"InitialState", (Object)0);
        this.variantArraySize = 1;
    }

    VariantContext getVariantContext() {
        return this.variantContext;
    }

    public Collection<String> getVariantIds() {
        return Collections.unmodifiableSet(this.id2index.keySet());
    }

    public int getVariantArraySize() {
        return this.variantArraySize;
    }

    int getVariantCount() {
        return this.id2index.size();
    }

    Collection<Integer> getVariantIndexes() {
        return this.id2index.values();
    }

    private int getVariantIndex(String variantId) {
        Integer index = (Integer)this.id2index.get((Object)variantId);
        if (index == null) {
            throw new PowsyblException("Variant '" + variantId + "' not found");
        }
        return index;
    }

    public String getVariantId(int variantIndex) {
        return (String)this.id2index.inverse().get((Object)variantIndex);
    }

    public String getWorkingVariantId() {
        int index = this.variantContext.getVariantIndex();
        return this.getVariantId(index);
    }

    public void setWorkingVariant(String variantId) {
        int index = this.getVariantIndex(variantId);
        this.variantContext.setVariantIndex(index);
    }

    private Iterable<MultiVariantObject> getStafulObjects() {
        return FluentIterable.from(this.networkIndex.getAll()).filter(MultiVariantObject.class);
    }

    public void cloneVariant(String sourceVariantId, String targetVariantId) {
        this.cloneVariant(sourceVariantId, Collections.singletonList(targetVariantId), false);
    }

    public void cloneVariant(String sourceVariantId, String targetVariantId, boolean mayOverwrite) {
        this.cloneVariant(sourceVariantId, Collections.singletonList(targetVariantId), mayOverwrite);
    }

    public void cloneVariant(String sourceVariantId, List<String> targetVariantIds) {
        this.cloneVariant(sourceVariantId, targetVariantIds, false);
    }

    public void cloneVariant(String sourceVariantId, List<String> targetVariantIds, boolean mayOverwrite) {
        if (targetVariantIds.isEmpty()) {
            throw new IllegalArgumentException("Empty target variant id list");
        }
        LOGGER.debug("Creating variants {}", targetVariantIds);
        int sourceIndex = this.getVariantIndex(sourceVariantId);
        int initVariantArraySize = this.variantArraySize;
        int extendedCount = 0;
        ArrayList<Integer> recycled = new ArrayList<Integer>();
        ArrayList<Integer> overwritten = new ArrayList<Integer>();
        for (String targetVariantId : targetVariantIds) {
            if (this.id2index.containsKey((Object)targetVariantId)) {
                if (mayOverwrite) {
                    overwritten.add((Integer)this.id2index.get((Object)targetVariantId));
                    this.network.getListeners().notifyVariantOverwritten(sourceVariantId, targetVariantId);
                    continue;
                }
                throw new PowsyblException("Target variant '" + targetVariantId + "' already exists");
            }
            if (this.unusedIndexes.isEmpty()) {
                this.id2index.put((Object)targetVariantId, (Object)this.variantArraySize);
                ++this.variantArraySize;
                ++extendedCount;
                this.network.getListeners().notifyVariantCreated(sourceVariantId, targetVariantId);
                continue;
            }
            int index = this.unusedIndexes.pollLast();
            this.id2index.put((Object)targetVariantId, (Object)index);
            recycled.add(index);
            this.network.getListeners().notifyVariantCreated(sourceVariantId, targetVariantId);
        }
        this.allocateVariantArrayElements(sourceIndex, recycled, overwritten);
        if (extendedCount > 0) {
            for (MultiVariantObject obj : this.getStafulObjects()) {
                obj.extendVariantArraySize(initVariantArraySize, extendedCount, sourceIndex);
            }
            LOGGER.trace("Extending variant array size to {} (+{})", (Object)this.variantArraySize, (Object)extendedCount);
        }
    }

    private void allocateVariantArrayElements(Integer sourceIndex, List<Integer> recycled, List<Integer> overwritten) {
        int[] indexes;
        if (!recycled.isEmpty()) {
            indexes = Ints.toArray(recycled);
            for (MultiVariantObject obj : this.getStafulObjects()) {
                obj.allocateVariantArrayElement(indexes, sourceIndex);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Recycling variant array indexes {}", (Object)Arrays.toString(indexes));
            }
        }
        if (!overwritten.isEmpty()) {
            indexes = Ints.toArray(overwritten);
            for (MultiVariantObject obj : this.getStafulObjects()) {
                obj.allocateVariantArrayElement(indexes, sourceIndex);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Overwriting variant array indexes {}", (Object)Arrays.toString(indexes));
            }
        }
    }

    public void removeVariant(String variantId) {
        if ("InitialState".equals(variantId)) {
            throw new PowsyblException("Removing initial variant is forbidden");
        }
        int index = this.getVariantIndex(variantId);
        this.id2index.remove((Object)variantId);
        LOGGER.debug("Removing variant '{}'", (Object)variantId);
        if (index == this.variantArraySize - 1) {
            int number = 0;
            HashSet<Integer> removed = new HashSet<Integer>();
            for (int j = index; j >= 0 && !this.id2index.containsValue((Object)j); --j) {
                ++number;
                removed.add(j);
            }
            this.unusedIndexes.removeAll(removed);
            for (MultiVariantObject obj : this.getStafulObjects()) {
                obj.reduceVariantArraySize(number);
            }
            this.variantArraySize -= number;
            LOGGER.trace("Reducing variant array size to {}", (Object)this.variantArraySize);
        } else {
            this.unusedIndexes.add(index);
            for (MultiVariantObject obj : this.getStafulObjects()) {
                obj.deleteVariantArrayElement(index);
            }
            LOGGER.trace("Deleting variant array element at index {}", (Object)index);
        }
        this.variantContext.resetIfVariantIndexIs(index);
        this.network.getListeners().notifyVariantRemoved(variantId);
    }

    public void allowVariantMultiThreadAccess(boolean allow) {
        if (allow && !(this.variantContext instanceof ThreadLocalMultiVariantContext)) {
            ThreadLocalMultiVariantContext newVariantContext = new ThreadLocalMultiVariantContext();
            if (this.variantContext.isIndexSet()) {
                newVariantContext.setVariantIndex(this.variantContext.getVariantIndex());
            }
            this.variantContext = newVariantContext;
        } else if (!allow && !(this.variantContext instanceof MultiVariantContext)) {
            this.variantContext = this.variantContext.isIndexSet() ? new MultiVariantContext(this.variantContext.getVariantIndex()) : new MultiVariantContext(0);
        }
    }

    public boolean isVariantMultiThreadAccessAllowed() {
        return this.variantContext instanceof ThreadLocalMultiVariantContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEachVariant(Runnable r) {
        int currentVariantIndex = this.variantContext.getVariantIndex();
        try {
            Iterator iterator = this.id2index.values().iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                this.variantContext.setVariantIndex(index);
                r.run();
            }
        }
        finally {
            this.variantContext.setVariantIndex(currentVariantIndex);
        }
    }
}

