/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.extensions.AbstractExtensionAdder;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.VoltageRegulation;
import com.powsybl.iidm.network.extensions.VoltageRegulationAdder;
import com.powsybl.iidm.network.impl.extensions.VoltageRegulationImpl;

public class VoltageRegulationAdderImpl
extends AbstractExtensionAdder<Battery, VoltageRegulation>
implements VoltageRegulationAdder {
    private Terminal regulatingTerminal;
    private Boolean voltageRegulatorOn = null;
    private double targetV = Double.NaN;

    public VoltageRegulationAdderImpl(Battery battery) {
        super((Extendable)battery);
    }

    protected VoltageRegulation createExtension(Battery battery) {
        if (this.regulatingTerminal == null) {
            this.regulatingTerminal = battery.getTerminal();
        }
        return new VoltageRegulationImpl(battery, this.regulatingTerminal, this.voltageRegulatorOn, this.targetV);
    }

    public VoltageRegulationAdder withVoltageRegulatorOn(boolean voltageRegulatorOn) {
        this.voltageRegulatorOn = voltageRegulatorOn;
        return this;
    }

    public VoltageRegulationAdder withTargetV(double targetV) {
        this.targetV = targetV;
        return this;
    }

    public VoltageRegulationAdder withRegulatingTerminal(Terminal terminal) {
        this.regulatingTerminal = terminal;
        return this;
    }
}

