/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtensionAdder;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.extensions.BranchObservability;
import com.powsybl.iidm.network.extensions.BranchObservabilityAdder;
import com.powsybl.iidm.network.impl.extensions.BranchObservabilityImpl;

public class BranchObservabilityAdderImpl<B extends Branch<B>>
extends AbstractExtensionAdder<B, BranchObservability<B>>
implements BranchObservabilityAdder<B> {
    private boolean observable;
    private double standardDeviationP1 = Double.NaN;
    private double standardDeviationP2 = Double.NaN;
    private double standardDeviationQ1 = Double.NaN;
    private double standardDeviationQ2 = Double.NaN;
    private Boolean redundantP1 = null;
    private Boolean redundantP2 = null;
    private Boolean redundantQ1 = null;
    private Boolean redundantQ2 = null;

    public BranchObservabilityAdderImpl(B extendable) {
        super(extendable);
    }

    protected BranchObservability<B> createExtension(B extendable) {
        BranchObservabilityImpl<B> extension = new BranchObservabilityImpl<B>(extendable, this.observable);
        if (!Double.isNaN(this.standardDeviationP1)) {
            extension.setQualityP1(this.standardDeviationP1, this.redundantP1);
        }
        if (!Double.isNaN(this.standardDeviationP2)) {
            extension.setQualityP2(this.standardDeviationP2, this.redundantP2);
        }
        if (!Double.isNaN(this.standardDeviationQ1)) {
            extension.setQualityQ1(this.standardDeviationQ1, this.redundantQ1);
        }
        if (!Double.isNaN(this.standardDeviationQ2)) {
            extension.setQualityQ2(this.standardDeviationQ2, this.redundantQ2);
        }
        return extension;
    }

    public BranchObservabilityAdder<B> withObservable(boolean observable) {
        this.observable = observable;
        return this;
    }

    public BranchObservabilityAdder<B> withStandardDeviationP1(double standardDeviationP1) {
        this.standardDeviationP1 = standardDeviationP1;
        return this;
    }

    public BranchObservabilityAdder<B> withStandardDeviationP2(double standardDeviationP2) {
        this.standardDeviationP2 = standardDeviationP2;
        return this;
    }

    public BranchObservabilityAdder<B> withRedundantP1(Boolean redundantP1) {
        this.redundantP1 = redundantP1;
        return this;
    }

    public BranchObservabilityAdder<B> withRedundantP2(Boolean redundantP2) {
        this.redundantP2 = redundantP2;
        return this;
    }

    public BranchObservabilityAdder<B> withStandardDeviationQ1(double standardDeviationQ1) {
        this.standardDeviationQ1 = standardDeviationQ1;
        return this;
    }

    public BranchObservabilityAdder<B> withStandardDeviationQ2(double standardDeviationQ2) {
        this.standardDeviationQ2 = standardDeviationQ2;
        return this;
    }

    public BranchObservabilityAdder<B> withRedundantQ1(Boolean redundantQ1) {
        this.redundantQ1 = redundantQ1;
        return this;
    }

    public BranchObservabilityAdder<B> withRedundantQ2(Boolean redundantQ2) {
        this.redundantQ2 = redundantQ2;
        return this;
    }
}

