/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtensionAdder;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.extensions.GeneratorStartup;
import com.powsybl.iidm.network.extensions.GeneratorStartupAdder;
import com.powsybl.iidm.network.impl.extensions.GeneratorStartupImpl;

public class GeneratorStartupAdderImpl
extends AbstractExtensionAdder<Generator, GeneratorStartup>
implements GeneratorStartupAdder {
    private double plannedActivePowerSetpoint = Double.NaN;
    private double startupCost = Double.NaN;
    private double marginalCost = Double.NaN;
    private double plannedOutageRate = Double.NaN;
    private double forcedOutageRate = Double.NaN;

    public GeneratorStartupAdderImpl(Generator generator) {
        super((Extendable)generator);
    }

    protected GeneratorStartup createExtension(Generator extendable) {
        return new GeneratorStartupImpl(extendable, this.plannedActivePowerSetpoint, this.startupCost, this.marginalCost, this.plannedOutageRate, this.forcedOutageRate);
    }

    public GeneratorStartupAdderImpl withPlannedActivePowerSetpoint(double plannedActivePowerSetpoint) {
        this.plannedActivePowerSetpoint = plannedActivePowerSetpoint;
        return this;
    }

    public GeneratorStartupAdder withStartupCost(double startUpCost) {
        this.startupCost = startUpCost;
        return this;
    }

    public GeneratorStartupAdderImpl withMarginalCost(double marginalCost) {
        this.marginalCost = marginalCost;
        return this;
    }

    public GeneratorStartupAdderImpl withPlannedOutageRate(double plannedOutageRate) {
        this.plannedOutageRate = plannedOutageRate;
        return this;
    }

    public GeneratorStartupAdderImpl withForcedOutageRate(double forcedOutageRate) {
        this.forcedOutageRate = forcedOutageRate;
        return this;
    }
}

