/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.extensions.HvdcAngleDroopActivePowerControl;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import gnu.trove.list.array.TFloatArrayList;
import java.util.Objects;

public class HvdcAngleDroopActivePowerControlImpl
extends AbstractMultiVariantIdentifiableExtension<HvdcLine>
implements HvdcAngleDroopActivePowerControl {
    private TFloatArrayList p0;
    private TFloatArrayList droop;
    private TBooleanArrayList enabled;

    public HvdcAngleDroopActivePowerControlImpl(HvdcLine hvdcLine, float p0, float droop, boolean enabled) {
        super(hvdcLine);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.p0 = new TFloatArrayList(variantArraySize);
        this.droop = new TFloatArrayList(variantArraySize);
        this.enabled = new TBooleanArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.p0.add(this.checkP0(p0, hvdcLine));
            this.droop.add(this.checkDroop(droop, hvdcLine));
            this.enabled.add(enabled);
        }
    }

    public float getP0() {
        return this.p0.get(this.getVariantIndex());
    }

    public float getDroop() {
        return this.droop.get(this.getVariantIndex());
    }

    public boolean isEnabled() {
        return this.enabled.get(this.getVariantIndex());
    }

    public HvdcAngleDroopActivePowerControl setP0(float p0) {
        this.p0.set(this.getVariantIndex(), this.checkP0(p0, (HvdcLine)this.getExtendable()));
        return this;
    }

    public HvdcAngleDroopActivePowerControl setDroop(float droop) {
        this.droop.set(this.getVariantIndex(), this.checkDroop(droop, (HvdcLine)this.getExtendable()));
        return this;
    }

    public HvdcAngleDroopActivePowerControl setEnabled(boolean enabled) {
        this.enabled.set(this.getVariantIndex(), enabled);
        return this;
    }

    private float checkP0(float p0, HvdcLine hvdcLine) {
        if (Float.isNaN(p0)) {
            throw new IllegalArgumentException(String.format("p0 value (%s) is invalid for HVDC line %s", Float.valueOf(p0), hvdcLine.getId()));
        }
        return p0;
    }

    private float checkDroop(float droop, HvdcLine hvdcLine) {
        if (Float.isNaN(droop)) {
            throw new IllegalArgumentException(String.format("droop value (%s) is invalid for HVDC line %s", Float.valueOf(droop), hvdcLine.getId()));
        }
        return droop;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HvdcAngleDroopActivePowerControlImpl that = (HvdcAngleDroopActivePowerControlImpl)o;
        return Float.compare(that.getP0(), this.getP0()) == 0 && Float.compare(that.getDroop(), this.getDroop()) == 0 && this.isEnabled() == that.isEnabled();
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.getP0()), Float.valueOf(this.getDroop()), this.isEnabled());
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.p0.ensureCapacity(this.p0.size() + number);
        this.droop.ensureCapacity(this.droop.size() + number);
        this.enabled.ensureCapacity(this.enabled.size() + number);
        for (int i = 0; i < number; ++i) {
            this.p0.add(this.p0.get(sourceIndex));
            this.droop.add(this.droop.get(sourceIndex));
            this.enabled.add(this.enabled.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.p0.remove(this.p0.size() - number, number);
        this.droop.remove(this.droop.size() - number, number);
        this.enabled.remove(this.enabled.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.p0.set(index, this.p0.get(sourceIndex));
            this.droop.set(index, this.droop.get(sourceIndex));
            this.enabled.set(index, this.enabled.get(sourceIndex));
        }
    }
}

