/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtensionAdder;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.extensions.InjectionObservability;
import com.powsybl.iidm.network.extensions.InjectionObservabilityAdder;
import com.powsybl.iidm.network.impl.extensions.InjectionObservabilityImpl;

public class InjectionObservabilityAdderImpl<I extends Injection<I>>
extends AbstractExtensionAdder<I, InjectionObservability<I>>
implements InjectionObservabilityAdder<I> {
    private boolean observable;
    private double standardDeviationP = Double.NaN;
    private double standardDeviationQ = Double.NaN;
    private double standardDeviationV = Double.NaN;
    private Boolean redundantP = null;
    private Boolean redundantQ = null;
    private Boolean redundantV = null;

    public InjectionObservabilityAdderImpl(I extendable) {
        super(extendable);
    }

    protected InjectionObservability<I> createExtension(I extendable) {
        InjectionObservabilityImpl<I> extension = new InjectionObservabilityImpl<I>(extendable, this.observable);
        if (!Double.isNaN(this.standardDeviationP)) {
            extension.setQualityP(this.standardDeviationP, this.redundantP);
        }
        if (!Double.isNaN(this.standardDeviationQ)) {
            extension.setQualityQ(this.standardDeviationQ, this.redundantQ);
        }
        if (!Double.isNaN(this.standardDeviationV)) {
            extension.setQualityV(this.standardDeviationV, this.redundantV);
        }
        return extension;
    }

    public InjectionObservabilityAdder<I> withObservable(boolean observable) {
        this.observable = observable;
        return this;
    }

    public InjectionObservabilityAdder<I> withStandardDeviationP(double standardDeviationP) {
        this.standardDeviationP = standardDeviationP;
        return this;
    }

    public InjectionObservabilityAdder<I> withRedundantP(Boolean redundant) {
        this.redundantP = redundant;
        return this;
    }

    public InjectionObservabilityAdder<I> withStandardDeviationQ(double standardDeviationQ) {
        this.standardDeviationQ = standardDeviationQ;
        return this;
    }

    public InjectionObservabilityAdder<I> withRedundantQ(Boolean redundant) {
        this.redundantQ = redundant;
        return this;
    }

    public InjectionObservabilityAdder<I> withStandardDeviationV(double standardDeviationV) {
        this.standardDeviationV = standardDeviationV;
        return this;
    }

    public InjectionObservabilityAdder<I> withRedundantV(Boolean redundant) {
        this.redundantV = redundant;
        return this;
    }
}

