/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.extensions.Measurement;
import com.powsybl.iidm.network.extensions.MeasurementAdder;
import com.powsybl.iidm.network.extensions.util.MeasurementValidationUtil;
import com.powsybl.iidm.network.impl.extensions.MeasurementImpl;
import com.powsybl.iidm.network.impl.extensions.MeasurementsImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class MeasurementAdderImpl
implements MeasurementAdder {
    private final MeasurementsImpl<? extends Connectable<?>> measurements;
    private final Map<String, String> properties = new HashMap<String, String>();
    private String id;
    private boolean idUnicity = false;
    private Measurement.Type type;
    private double value = Double.NaN;
    private double standardDeviation = Double.NaN;
    private boolean valid = true;
    private ThreeSides side;

    MeasurementAdderImpl(MeasurementsImpl<? extends Connectable<?>> measurements) {
        this.measurements = Objects.requireNonNull(measurements);
    }

    public MeasurementAdder setId(String id) {
        this.id = id;
        return this;
    }

    public MeasurementAdder putProperty(String name, String property) {
        this.properties.put(name, property);
        return this;
    }

    public MeasurementAdder setType(Measurement.Type type) {
        this.type = type;
        return this;
    }

    public MeasurementAdder setValue(double value) {
        this.value = value;
        return this;
    }

    public MeasurementAdder setStandardDeviation(double standardDeviation) {
        this.standardDeviation = standardDeviation;
        return this;
    }

    public MeasurementAdder setSide(ThreeSides side) {
        this.side = side;
        return this;
    }

    public MeasurementAdder setValid(boolean valid) {
        this.valid = valid;
        return this;
    }

    public MeasurementAdder setEnsureIdUnicity(boolean idUnicity) {
        this.idUnicity = idUnicity;
        return this;
    }

    public Measurement add() {
        this.id = MeasurementValidationUtil.checkId((String)this.id, (boolean)this.idUnicity, this.measurements);
        if (this.type == null) {
            throw new PowsyblException("Measurement type can not be null");
        }
        MeasurementValidationUtil.checkValue((double)this.value, (boolean)this.valid);
        MeasurementValidationUtil.checkSide((Measurement.Type)this.type, (ThreeSides)this.side, (Connectable)((Connectable)this.measurements.getExtendable()));
        MeasurementImpl measurement = new MeasurementImpl(this.measurements, this.id, this.type, this.properties, this.value, this.standardDeviation, this.valid, this.side);
        this.measurements.add(measurement);
        return measurement;
    }
}

