/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.google.common.collect.ImmutableSet;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.ReferenceTerminals;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import com.powsybl.iidm.network.impl.TerminalExt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

class ReferenceTerminalsImpl
extends AbstractMultiVariantIdentifiableExtension<Network>
implements ReferenceTerminals {
    private final ArrayList<Set<Terminal>> terminalsPerVariant = new ArrayList<LinkedHashSet<Set<Terminal>>>(Collections.nCopies(this.getVariantManagerHolder().getVariantManager().getVariantArraySize(), new LinkedHashSet()));

    public ReferenceTerminalsImpl(Network network, Set<Terminal> terminals) {
        super(network);
        this.setReferenceTerminals(terminals);
    }

    private void unregisterReferencedTerminalIfNeeded(int variantIndex) {
        Set<Terminal> oldTerminals = this.terminalsPerVariant.get(variantIndex);
        for (Terminal oldTerminal : oldTerminals) {
            if (this.terminalsPerVariant.stream().flatMap(Collection::stream).filter(t -> t == oldTerminal).count() != 1L) continue;
            ((TerminalExt)oldTerminal).getReferrerManager().unregister(this);
        }
    }

    private void registerReferencedTerminalIfNeeded(Set<Terminal> terminals) {
        for (Terminal terminal : terminals) {
            if (!this.terminalsPerVariant.stream().flatMap(Collection::stream).noneMatch(t -> t == terminal)) continue;
            ((TerminalExt)terminal).getReferrerManager().register(this);
        }
    }

    private void setTerminalsAndUpdateReferences(int variantIndex, Set<Terminal> terminals) {
        this.unregisterReferencedTerminalIfNeeded(variantIndex);
        this.registerReferencedTerminalIfNeeded(terminals);
        this.terminalsPerVariant.set(variantIndex, new LinkedHashSet<Terminal>(terminals));
    }

    private void addTerminalsAndUpdateReferences(Set<Terminal> terminals) {
        this.registerReferencedTerminalIfNeeded(terminals);
        this.terminalsPerVariant.add(new LinkedHashSet<Terminal>(terminals));
    }

    private void updateTerminalsAndUpdateReferences(int variantIndex, Terminal terminal) {
        this.registerReferencedTerminalIfNeeded(Set.of(terminal));
        this.terminalsPerVariant.get(variantIndex).add(terminal);
    }

    private void removeTerminalsAndUpdateReferences(int variantIndex) {
        this.unregisterReferencedTerminalIfNeeded(variantIndex);
        this.terminalsPerVariant.remove(variantIndex);
    }

    public Set<Terminal> getReferenceTerminals() {
        return ImmutableSet.copyOf((Collection)this.terminalsPerVariant.get(this.getVariantIndex()));
    }

    public void setReferenceTerminals(Set<Terminal> terminals) {
        Objects.requireNonNull(terminals);
        terminals.forEach(t -> ReferenceTerminalsImpl.checkTerminalInNetwork(t, (Network)this.getExtendable()));
        this.setTerminalsAndUpdateReferences(this.getVariantIndex(), terminals);
    }

    public ReferenceTerminals reset() {
        this.setTerminalsAndUpdateReferences(this.getVariantIndex(), Collections.emptySet());
        return this;
    }

    public ReferenceTerminals addReferenceTerminal(Terminal terminal) {
        Objects.requireNonNull(terminal);
        ReferenceTerminalsImpl.checkTerminalInNetwork(terminal, (Network)this.getExtendable());
        this.updateTerminalsAndUpdateReferences(this.getVariantIndex(), terminal);
        return this;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.terminalsPerVariant.ensureCapacity(this.terminalsPerVariant.size() + number);
        Set<Terminal> sourceTerminals = this.terminalsPerVariant.get(sourceIndex);
        for (int i = 0; i < number; ++i) {
            this.addTerminalsAndUpdateReferences(sourceTerminals);
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        for (int i = 0; i < number; ++i) {
            this.removeTerminalsAndUpdateReferences(this.terminalsPerVariant.size() - 1);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.setTerminalsAndUpdateReferences(index, Collections.emptySet());
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        Set<Terminal> sourceTerminals = this.terminalsPerVariant.get(sourceIndex);
        for (int index : indexes) {
            this.setTerminalsAndUpdateReferences(index, sourceTerminals);
        }
    }

    private static void checkTerminalInNetwork(Terminal terminal, Network network) {
        boolean extendableIsRootNetwork = network.getNetwork().equals(network);
        if (extendableIsRootNetwork) {
            if (!terminal.getVoltageLevel().getNetwork().equals(network)) {
                throw new PowsyblException("Terminal given is not in the right Network (" + terminal.getVoltageLevel().getNetwork().getId() + " instead of " + network.getId() + ")");
            }
        } else if (!terminal.getVoltageLevel().getParentNetwork().equals(network)) {
            throw new PowsyblException("Terminal given is not in the right Network (" + terminal.getVoltageLevel().getParentNetwork().getId() + " instead of " + network.getId() + ")");
        }
    }

    @Override
    public void onReferencedRemoval(Terminal removedTerminal) {
        for (Set<Terminal> terminals : this.terminalsPerVariant) {
            terminals.remove(removedTerminal);
        }
    }

    public void cleanup() {
        for (Set<Terminal> terminals : this.terminalsPerVariant) {
            for (Terminal terminal : terminals) {
                ((TerminalExt)terminal).getReferrerManager().unregister(this);
            }
            terminals.clear();
        }
    }
}

