/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtensionAdder;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.extensions.FortescueConstants;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerFortescue;
import com.powsybl.iidm.network.extensions.ThreeWindingsTransformerFortescueAdder;
import com.powsybl.iidm.network.extensions.WindingConnectionType;
import com.powsybl.iidm.network.impl.extensions.ThreeWindingsTransformerFortescueImpl;
import java.util.Objects;

public class ThreeWindingsTransformerFortescueAdderImpl
extends AbstractExtensionAdder<ThreeWindingsTransformer, ThreeWindingsTransformerFortescue>
implements ThreeWindingsTransformerFortescueAdder {
    private final LegFortescueAdderImpl legAdder1 = new LegFortescueAdderImpl(FortescueConstants.DEFAULT_LEG1_CONNECTION_TYPE);
    private final LegFortescueAdderImpl legAdder2 = new LegFortescueAdderImpl(FortescueConstants.DEFAULT_LEG2_CONNECTION_TYPE);
    private final LegFortescueAdderImpl legAdder3 = new LegFortescueAdderImpl(FortescueConstants.DEFAULT_LEG3_CONNECTION_TYPE);

    public ThreeWindingsTransformerFortescueAdderImpl(ThreeWindingsTransformer twt) {
        super((Extendable)twt);
    }

    public Class<? super ThreeWindingsTransformerFortescue> getExtensionClass() {
        return ThreeWindingsTransformerFortescue.class;
    }

    protected ThreeWindingsTransformerFortescueImpl createExtension(ThreeWindingsTransformer twt) {
        ThreeWindingsTransformerFortescue.LegFortescue leg1 = new ThreeWindingsTransformerFortescue.LegFortescue(this.legAdder1.rz, this.legAdder1.xz, this.legAdder1.freeFluxes, this.legAdder1.connectionType, this.legAdder1.groundingR, this.legAdder1.groundingX);
        ThreeWindingsTransformerFortescue.LegFortescue leg2 = new ThreeWindingsTransformerFortescue.LegFortescue(this.legAdder2.rz, this.legAdder2.xz, this.legAdder2.freeFluxes, this.legAdder2.connectionType, this.legAdder2.groundingR, this.legAdder2.groundingX);
        ThreeWindingsTransformerFortescue.LegFortescue leg3 = new ThreeWindingsTransformerFortescue.LegFortescue(this.legAdder3.rz, this.legAdder3.xz, this.legAdder3.freeFluxes, this.legAdder3.connectionType, this.legAdder3.groundingR, this.legAdder3.groundingX);
        return new ThreeWindingsTransformerFortescueImpl(twt, leg1, leg2, leg3);
    }

    public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder leg1() {
        return this.legAdder1;
    }

    public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder leg2() {
        return this.legAdder2;
    }

    public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder leg3() {
        return this.legAdder3;
    }

    private class LegFortescueAdderImpl
    implements ThreeWindingsTransformerFortescueAdder.LegFortescueAdder {
        private double rz = Double.NaN;
        private double xz = Double.NaN;
        private boolean freeFluxes = true;
        private WindingConnectionType connectionType;
        private double groundingR = 0.0;
        private double groundingX = 0.0;

        public LegFortescueAdderImpl(WindingConnectionType connectionType) {
            this.connectionType = Objects.requireNonNull(connectionType);
        }

        public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder withRz(double rz) {
            this.rz = rz;
            return this;
        }

        public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder withXz(double xz) {
            this.xz = xz;
            return this;
        }

        public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder withFreeFluxes(boolean freeFluxes) {
            this.freeFluxes = freeFluxes;
            return this;
        }

        public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder withConnectionType(WindingConnectionType connectionType) {
            this.connectionType = Objects.requireNonNull(connectionType);
            return this;
        }

        public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder withGroundingR(double groundingR) {
            this.groundingR = groundingR;
            return this;
        }

        public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder withGroundingX(double groundingX) {
            this.groundingX = groundingX;
            return this;
        }

        public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder leg1() {
            return ThreeWindingsTransformerFortescueAdderImpl.this.legAdder1;
        }

        public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder leg2() {
            return ThreeWindingsTransformerFortescueAdderImpl.this.legAdder2;
        }

        public ThreeWindingsTransformerFortescueAdder.LegFortescueAdder leg3() {
            return ThreeWindingsTransformerFortescueAdderImpl.this.legAdder3;
        }

        public ThreeWindingsTransformerFortescue add() {
            return (ThreeWindingsTransformerFortescue)ThreeWindingsTransformerFortescueAdderImpl.this.add();
        }
    }
}

