/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.extensions.VoltageRegulation;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import gnu.trove.list.array.TDoubleArrayList;

public class VoltageRegulationImpl
extends AbstractMultiVariantIdentifiableExtension<Battery>
implements VoltageRegulation {
    private final TBooleanArrayList voltageRegulatorOn;
    private final TDoubleArrayList targetV;
    private Terminal regulatingTerminal;

    public VoltageRegulationImpl(Battery battery, Terminal regulatingTerminal, Boolean voltageRegulatorOn, double targetV) {
        super(battery);
        VoltageRegulationImpl.checkRegulatingTerminal(regulatingTerminal, this.getNetworkFromExtendable());
        if (voltageRegulatorOn == null) {
            throw new PowsyblException("Voltage regulator status is not defined");
        }
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.setRegulatingTerminal(regulatingTerminal);
        this.voltageRegulatorOn = new TBooleanArrayList(variantArraySize);
        this.targetV = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.voltageRegulatorOn.add(voltageRegulatorOn.booleanValue());
            this.targetV.add(targetV);
        }
    }

    private static void checkRegulatingTerminal(Terminal regulatingTerminal, Network network) {
        if (regulatingTerminal != null && regulatingTerminal.getVoltageLevel().getNetwork() != network) {
            throw new PowsyblException("regulating terminal is not part of the same network");
        }
    }

    public Terminal getRegulatingTerminal() {
        return this.regulatingTerminal;
    }

    public void setRegulatingTerminal(Terminal regulatingTerminal) {
        VoltageRegulationImpl.checkRegulatingTerminal(regulatingTerminal, this.getNetworkFromExtendable());
        this.regulatingTerminal = regulatingTerminal != null ? regulatingTerminal : ((Battery)this.getExtendable()).getTerminal();
    }

    public boolean isVoltageRegulatorOn() {
        return this.voltageRegulatorOn.get(this.getVariantIndex());
    }

    public void setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        this.voltageRegulatorOn.set(this.getVariantIndex(), voltageRegulatorOn);
    }

    public double getTargetV() {
        return this.targetV.get(this.getVariantIndex());
    }

    public void setTargetV(double targetV) {
        this.targetV.set(this.getVariantIndex(), targetV);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.voltageRegulatorOn.ensureCapacity(this.voltageRegulatorOn.size() + number);
        this.targetV.ensureCapacity(this.targetV.size() + number);
        for (int i = 0; i < number; ++i) {
            this.voltageRegulatorOn.add(this.voltageRegulatorOn.get(sourceIndex));
            this.targetV.add(this.targetV.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.voltageRegulatorOn.remove(this.voltageRegulatorOn.size() - number, number);
        this.targetV.remove(this.targetV.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.voltageRegulatorOn.set(index, this.voltageRegulatorOn.get(sourceIndex));
            this.targetV.set(index, this.targetV.get(sourceIndex));
        }
    }

    private Network getNetworkFromExtendable() {
        return ((Battery)this.getExtendable()).getTerminal().getVoltageLevel().getNetwork();
    }
}

