/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.FluentIterable;
import com.google.common.primitives.Ints;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.TopologyModel;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.util.ShortIdDictionary;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;

abstract class AbstractTopologyModel
implements TopologyModel {
    public static final int DEFAULT_NODE_INDEX_LIMIT = 1000;
    public static final int NODE_INDEX_LIMIT = AbstractTopologyModel.loadNodeIndexLimit(PlatformConfig.defaultConfig());
    protected final VoltageLevelExt voltageLevel;

    protected AbstractTopologyModel(VoltageLevelExt voltageLevel) {
        this.voltageLevel = Objects.requireNonNull(voltageLevel);
    }

    protected static int loadNodeIndexLimit(PlatformConfig platformConfig) {
        return platformConfig.getOptionalModuleConfig("iidm").map(moduleConfig -> moduleConfig.getIntProperty("node-index-limit", 1000)).orElse(1000);
    }

    protected NetworkImpl getNetwork() {
        return this.voltageLevel.getNetwork();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void addNextTerminals(TerminalExt otherTerminal, List<TerminalExt> nextTerminals) {
        Objects.requireNonNull(otherTerminal);
        Objects.requireNonNull(nextTerminals);
        AbstractConnectable otherConnectable = otherTerminal.getConnectable();
        if (otherConnectable instanceof Branch) {
            Branch branch = (Branch)otherConnectable;
            if (branch.getTerminal1() == otherTerminal) {
                nextTerminals.add((TerminalExt)branch.getTerminal2());
                return;
            } else {
                if (branch.getTerminal2() != otherTerminal) throw new IllegalStateException();
                nextTerminals.add((TerminalExt)branch.getTerminal1());
            }
            return;
        } else {
            if (!(otherConnectable instanceof ThreeWindingsTransformer)) return;
            ThreeWindingsTransformer ttc = (ThreeWindingsTransformer)otherConnectable;
            if (ttc.getLeg1().getTerminal() == otherTerminal) {
                nextTerminals.add((TerminalExt)ttc.getLeg2().getTerminal());
                nextTerminals.add((TerminalExt)ttc.getLeg3().getTerminal());
                return;
            } else if (ttc.getLeg2().getTerminal() == otherTerminal) {
                nextTerminals.add((TerminalExt)ttc.getLeg1().getTerminal());
                nextTerminals.add((TerminalExt)ttc.getLeg3().getTerminal());
                return;
            } else {
                if (ttc.getLeg3().getTerminal() != otherTerminal) throw new IllegalStateException();
                nextTerminals.add((TerminalExt)ttc.getLeg1().getTerminal());
                nextTerminals.add((TerminalExt)ttc.getLeg2().getTerminal());
            }
        }
    }

    @Override
    public void invalidateCache() {
        this.invalidateCache(false);
    }

    public abstract Iterable<Terminal> getTerminals();

    public abstract Stream<Terminal> getTerminalStream();

    public <T extends Connectable> Iterable<T> getConnectables(Class<T> clazz) {
        Iterable<Terminal> terminals = this.getTerminals();
        return FluentIterable.from(terminals).transform(Terminal::getConnectable).filter(clazz).toSet();
    }

    public <T extends Connectable> Stream<T> getConnectableStream(Class<T> clazz) {
        return this.getTerminalStream().map(Terminal::getConnectable).filter(clazz::isInstance).map(clazz::cast).distinct();
    }

    public <T extends Connectable> int getConnectableCount(Class<T> clazz) {
        return Ints.checkedCast((long)this.getConnectableStream(clazz).count());
    }

    public Iterable<Connectable> getConnectables() {
        return FluentIterable.from(this.getTerminals()).transform(Terminal::getConnectable).toSet();
    }

    public Stream<Connectable> getConnectableStream() {
        return this.getTerminalStream().map(Terminal::getConnectable).distinct();
    }

    public abstract VoltageLevelExt.NodeBreakerViewExt getNodeBreakerView();

    public abstract VoltageLevelExt.BusBreakerViewExt getBusBreakerView();

    public abstract VoltageLevelExt.BusViewExt getBusView();

    public abstract Iterable<Switch> getSwitches();

    public abstract int getSwitchCount();

    public abstract TopologyKind getTopologyKind();

    public abstract void extendVariantArraySize(int var1, int var2, int var3);

    public abstract void reduceVariantArraySize(int var1);

    public abstract void deleteVariantArrayElement(int var1);

    public abstract void allocateVariantArrayElement(int[] var1, int var2);

    protected abstract void removeTopology();

    public abstract void printTopology();

    public abstract void printTopology(PrintStream var1, ShortIdDictionary var2);

    public abstract void exportTopology(Path var1) throws IOException;

    public abstract void exportTopology(Writer var1);

    public abstract void exportTopology(Writer var1, Random var2);
}

