/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.OperationalLimits;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.ActivePowerLimitsAdderImpl;
import com.powsybl.iidm.network.impl.ApparentPowerLimitsAdderImpl;
import com.powsybl.iidm.network.impl.CurrentLimitsAdderImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.NetworkListenerList;
import java.util.Objects;
import java.util.Optional;

public class OperationalLimitsGroupImpl
implements OperationalLimitsGroup,
Validable {
    private final String id;
    private CurrentLimits currentLimits;
    private ActivePowerLimits activePowerLimits;
    private ApparentPowerLimits apparentPowerLimits;
    private final Identifiable<?> identifiable;
    private final NetworkListenerList listeners;
    private final Validable validable;
    private final String attributeName;
    private String selectedGroupId;

    OperationalLimitsGroupImpl(String id, AbstractIdentifiable<?> identifiable, String attributeName, String selectedGroupId) {
        this(id, (Identifiable)Objects.requireNonNull(identifiable), identifiable.getNetwork().getListeners(), identifiable, attributeName, selectedGroupId);
    }

    public OperationalLimitsGroupImpl(String id, Identifiable<?> identifiable, NetworkListenerList listeners, Validable validable, String attributeName, String selectedGroupId) {
        this.id = Objects.requireNonNull(id);
        this.identifiable = Objects.requireNonNull(identifiable);
        this.listeners = listeners;
        this.validable = Objects.requireNonNull(validable);
        this.attributeName = Objects.requireNonNull(attributeName);
        this.selectedGroupId = selectedGroupId;
    }

    public String getId() {
        return this.id;
    }

    public Optional<CurrentLimits> getCurrentLimits() {
        return Optional.ofNullable(this.currentLimits);
    }

    public Optional<ActivePowerLimits> getActivePowerLimits() {
        return Optional.ofNullable(this.activePowerLimits);
    }

    public Optional<ApparentPowerLimits> getApparentPowerLimits() {
        return Optional.ofNullable(this.apparentPowerLimits);
    }

    public CurrentLimitsAdder newCurrentLimits() {
        return new CurrentLimitsAdderImpl(() -> this, this.validable, this.identifiable.getId(), this.getNetwork());
    }

    public ActivePowerLimitsAdder newActivePowerLimits() {
        return new ActivePowerLimitsAdderImpl(() -> this, this.validable, this.identifiable.getId(), this.getNetwork());
    }

    public ApparentPowerLimitsAdder newApparentPowerLimits() {
        return new ApparentPowerLimitsAdderImpl(() -> this, this.validable, this.identifiable.getId(), this.getNetwork());
    }

    public void removeCurrentLimits() {
        this.setCurrentLimits(null);
    }

    public void removeActivePowerLimits() {
        this.setActivePowerLimits(null);
    }

    public void removeApparentPowerLimits() {
        this.setApparentPowerLimits(null);
    }

    public NetworkImpl getNetwork() {
        return (NetworkImpl)this.identifiable.getNetwork();
    }

    public void setCurrentLimits(CurrentLimits limits) {
        CurrentLimits oldValue = this.currentLimits;
        this.currentLimits = limits;
        this.notifyUpdate(LimitType.CURRENT, (OperationalLimits)oldValue, (OperationalLimits)limits);
    }

    public void setActivePowerLimits(ActivePowerLimits limits) {
        ActivePowerLimits oldValue = this.activePowerLimits;
        this.activePowerLimits = limits;
        this.notifyUpdate(LimitType.ACTIVE_POWER, (OperationalLimits)oldValue, (OperationalLimits)limits);
    }

    public void setApparentPowerLimits(ApparentPowerLimits limits) {
        ApparentPowerLimits oldValue = this.apparentPowerLimits;
        this.apparentPowerLimits = limits;
        this.notifyUpdate(LimitType.APPARENT_POWER, (OperationalLimits)oldValue, (OperationalLimits)limits);
    }

    public Validable getValidable() {
        return this.validable;
    }

    public void notifyPermanentLimitUpdate(LimitType limitType, double oldValue, double newValue) {
        PermanentLimitInfo oldPermanentLimitInfo = new PermanentLimitInfo(oldValue, this.id, this.id.equals(this.selectedGroupId));
        PermanentLimitInfo newPermanentLimitInfo = new PermanentLimitInfo(newValue, this.id, this.id.equals(this.selectedGroupId));
        this.doNotify(this.attributeName + "_" + limitType + ".permanentLimit", oldPermanentLimitInfo, newPermanentLimitInfo);
    }

    private void notifyUpdate(LimitType limitType, OperationalLimits oldValue, OperationalLimits newValue) {
        OperationalLimitsInfo oldOperationalLimitsInfo = new OperationalLimitsInfo(oldValue, this.id, this.id.equals(this.selectedGroupId));
        OperationalLimitsInfo newOperationalLimitsInfo = new OperationalLimitsInfo(newValue, this.id, this.id.equals(this.selectedGroupId));
        this.doNotify(this.attributeName + "_" + limitType, oldOperationalLimitsInfo, newOperationalLimitsInfo);
    }

    public void notifyTemporaryLimitValueUpdate(LimitType limitType, double oldValue, double newValue, int acceptableDuration) {
        TemporaryLimitInfo oldTemporaryLimitInfo = new TemporaryLimitInfo(oldValue, this.id, this.id.equals(this.selectedGroupId), acceptableDuration);
        TemporaryLimitInfo newTemporaryLimitInfo = new TemporaryLimitInfo(newValue, this.id, this.id.equals(this.selectedGroupId), acceptableDuration);
        this.doNotify(this.attributeName + "_" + limitType + ".temporaryLimit.value", oldTemporaryLimitInfo, newTemporaryLimitInfo);
    }

    private void doNotify(String attribute, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            this.listeners.notifyUpdate(this.identifiable, attribute, oldValue, newValue);
        }
    }

    public String getMessageHeader() {
        return this.validable.getMessageHeader();
    }

    public boolean isEmpty() {
        return this.currentLimits == null && this.apparentPowerLimits == null && this.activePowerLimits == null;
    }

    public void setSelectedGroupId(String selectedGroupId) {
        this.selectedGroupId = selectedGroupId;
    }

    public record PermanentLimitInfo(double value, String groupId, boolean inSelectedGroup) {
    }

    public record OperationalLimitsInfo(OperationalLimits value, String groupId, boolean inSelectedGroup) {
    }

    public record TemporaryLimitInfo(double value, String groupId, boolean inSelectedGroup, int acceptableDuration) {
    }
}

