/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.impl.Referrer;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class ReferrerManager<T> {
    private final T referenced;
    private final List<Referrer<T>> referrers = new CopyOnWriteArrayList<Referrer<T>>();

    public ReferrerManager(T referenced) {
        this.referenced = Objects.requireNonNull(referenced);
    }

    public List<Referrer<T>> getReferrers() {
        return this.referrers;
    }

    public void register(Referrer<T> referrer) {
        this.referrers.add(Objects.requireNonNull(referrer));
    }

    public void unregister(Referrer<T> referrer) {
        this.referrers.remove(Objects.requireNonNull(referrer));
    }

    public void notifyOfRemoval() {
        for (Referrer<T> referrer : this.referrers) {
            referrer.onReferencedRemoval(this.referenced);
        }
    }
}

