/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.ShuntCompensatorLinearModelAdder;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModelAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractInjectionAdder;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.ShuntCompensatorImpl;
import com.powsybl.iidm.network.impl.ShuntCompensatorLinearModelImpl;
import com.powsybl.iidm.network.impl.ShuntCompensatorModelExt;
import com.powsybl.iidm.network.impl.ShuntCompensatorNonLinearModelImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class ShuntCompensatorAdderImpl
extends AbstractInjectionAdder<ShuntCompensatorAdderImpl>
implements ShuntCompensatorAdder {
    private ShuntCompensatorModelBuilder modelBuilder;
    private Integer sectionCount;
    private double targetV = Double.NaN;
    private double targetDeadband = Double.NaN;
    private TerminalExt regulatingTerminal;
    private boolean voltageRegulatorOn = false;

    ShuntCompensatorAdderImpl(VoltageLevelExt voltageLevel) {
        this.voltageLevel = voltageLevel;
    }

    @Override
    protected String getTypeDescription() {
        return "Shunt compensator";
    }

    public ShuntCompensatorLinearModelAdder newLinearModel() {
        return new ShuntCompensatorLinearModelAdderImpl();
    }

    public ShuntCompensatorNonLinearModelAdder newNonLinearModel() {
        return new ShuntCompensatorNonLinearModelAdderImpl();
    }

    public ShuntCompensatorAdder setSectionCount(int sectionCount) {
        this.sectionCount = sectionCount;
        return this;
    }

    public ShuntCompensatorAdder setRegulatingTerminal(Terminal regulatingTerminal) {
        this.regulatingTerminal = (TerminalExt)regulatingTerminal;
        return this;
    }

    public ShuntCompensatorAdder setVoltageRegulatorOn(boolean voltageRegulatorOn) {
        this.voltageRegulatorOn = voltageRegulatorOn;
        return this;
    }

    public ShuntCompensatorAdder setTargetV(double targetV) {
        this.targetV = targetV;
        return this;
    }

    public ShuntCompensatorAdder setTargetDeadband(double targetDeadband) {
        this.targetDeadband = targetDeadband;
        return this;
    }

    public ShuntCompensatorImpl add() {
        NetworkImpl network = this.getNetwork();
        String id = this.checkAndGetUniqueId();
        TerminalExt terminal = this.checkAndGetTerminal();
        if (this.modelBuilder == null) {
            throw new ValidationException((Validable)this, "the shunt compensator model has not been defined");
        }
        ValidationUtil.checkRegulatingTerminal((Validable)this, (Terminal)this.regulatingTerminal, (Network)network);
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkVoltageControl((Validable)this, (boolean)this.voltageRegulatorOn, (double)this.targetV, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkTargetDeadband((Validable)this, (String)"shunt compensator", (boolean)this.voltageRegulatorOn, (double)this.targetDeadband, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkSections((Validable)this, (Integer)this.sectionCount, (int)this.modelBuilder.getMaximumSectionCount(), (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        ShuntCompensatorImpl shunt = new ShuntCompensatorImpl(this.getNetworkRef(), id, this.getName(), this.isFictitious(), this.modelBuilder.build(), this.sectionCount, this.regulatingTerminal, this.voltageRegulatorOn, this.targetV, this.targetDeadband);
        shunt.addTerminal(terminal);
        this.voltageLevel.getTopologyModel().attach(terminal, false);
        network.getIndex().checkAndAdd(shunt);
        network.getListeners().notifyCreation(shunt);
        return shunt;
    }

    class ShuntCompensatorLinearModelAdderImpl
    implements ShuntCompensatorLinearModelAdder,
    ShuntCompensatorModelBuilder {
        private double bPerSection = Double.NaN;
        private double gPerSection = Double.NaN;
        private int maximumSectionCount = -1;

        ShuntCompensatorLinearModelAdderImpl() {
        }

        public ShuntCompensatorLinearModelAdder setBPerSection(double bPerSection) {
            this.bPerSection = bPerSection;
            return this;
        }

        public ShuntCompensatorLinearModelAdder setGPerSection(double gPerSection) {
            this.gPerSection = gPerSection;
            return this;
        }

        @Override
        public int getMaximumSectionCount() {
            return this.maximumSectionCount;
        }

        public ShuntCompensatorLinearModelAdder setMaximumSectionCount(int maximumSectionCount) {
            this.maximumSectionCount = maximumSectionCount;
            return this;
        }

        public ShuntCompensatorAdder add() {
            ValidationUtil.checkBPerSection((Validable)ShuntCompensatorAdderImpl.this, (double)this.bPerSection);
            ValidationUtil.checkMaximumSectionCount((Validable)ShuntCompensatorAdderImpl.this, (int)this.maximumSectionCount);
            ShuntCompensatorAdderImpl.this.modelBuilder = this;
            return ShuntCompensatorAdderImpl.this;
        }

        @Override
        public ShuntCompensatorModelExt build() {
            return new ShuntCompensatorLinearModelImpl(this.bPerSection, this.gPerSection, this.maximumSectionCount);
        }
    }

    class ShuntCompensatorNonLinearModelAdderImpl
    implements ShuntCompensatorNonLinearModelAdder,
    ShuntCompensatorModelBuilder {
        private final List<SectionAdderImpl> sectionAdders = new ArrayList<SectionAdderImpl>();

        ShuntCompensatorNonLinearModelAdderImpl() {
        }

        public ShuntCompensatorNonLinearModelAdder.SectionAdder beginSection() {
            return new SectionAdderImpl();
        }

        public ShuntCompensatorAdder add() {
            if (this.sectionAdders.isEmpty()) {
                throw new ValidationException((Validable)ShuntCompensatorAdderImpl.this, "a shunt compensator must have at least one section");
            }
            ShuntCompensatorAdderImpl.this.modelBuilder = this;
            return ShuntCompensatorAdderImpl.this;
        }

        @Override
        public ShuntCompensatorModelExt build() {
            List<ShuntCompensatorNonLinearModelImpl.SectionImpl> sections = IntStream.range(0, this.sectionAdders.size()).mapToObj(s -> {
                SectionAdderImpl adder = this.sectionAdders.get(s);
                return new ShuntCompensatorNonLinearModelImpl.SectionImpl(s + 1, adder.b, adder.g);
            }).collect(Collectors.toList());
            return new ShuntCompensatorNonLinearModelImpl(sections);
        }

        @Override
        public int getMaximumSectionCount() {
            return this.sectionAdders.size();
        }

        class SectionAdderImpl
        implements ShuntCompensatorNonLinearModelAdder.SectionAdder {
            private double b = Double.NaN;
            private double g = Double.NaN;

            SectionAdderImpl() {
            }

            public ShuntCompensatorNonLinearModelAdder.SectionAdder setB(double b) {
                this.b = b;
                return this;
            }

            public ShuntCompensatorNonLinearModelAdder.SectionAdder setG(double g) {
                this.g = g;
                return this;
            }

            public ShuntCompensatorNonLinearModelAdder endSection() {
                ValidationUtil.checkBPerSection((Validable)ShuntCompensatorAdderImpl.this, (double)this.b);
                if (Double.isNaN(this.g)) {
                    this.g = ShuntCompensatorNonLinearModelAdderImpl.this.sectionAdders.isEmpty() ? 0.0 : ShuntCompensatorNonLinearModelAdderImpl.this.sectionAdders.get((int)(ShuntCompensatorNonLinearModelAdderImpl.this.sectionAdders.size() - 1)).g;
                }
                ShuntCompensatorNonLinearModelAdderImpl.this.sectionAdders.add(this);
                return ShuntCompensatorNonLinearModelAdderImpl.this;
            }
        }
    }

    static interface ShuntCompensatorModelBuilder {
        public int getMaximumSectionCount();

        public ShuntCompensatorModelExt build();
    }
}

