/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ShuntCompensatorModelType;
import com.powsybl.iidm.network.ShuntCompensatorNonLinearModel;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.ShuntCompensatorImpl;
import com.powsybl.iidm.network.impl.ShuntCompensatorModelExt;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class ShuntCompensatorNonLinearModelImpl
implements ShuntCompensatorModelExt,
ShuntCompensatorNonLinearModel {
    private ShuntCompensatorImpl shuntCompensator;
    private final List<SectionImpl> sections;

    ShuntCompensatorNonLinearModelImpl(List<SectionImpl> sections) {
        this.sections = Objects.requireNonNull(sections);
    }

    @Override
    public ShuntCompensatorNonLinearModelImpl attach(ShuntCompensatorImpl shuntCompensator) {
        if (this.shuntCompensator != null) {
            throw new IllegalStateException("ShuntCompensatorNonLinearModelImpl already attached to " + this.shuntCompensator.getId());
        }
        this.shuntCompensator = Objects.requireNonNull(shuntCompensator);
        for (SectionImpl section : this.sections) {
            section.attach(shuntCompensator);
        }
        return this;
    }

    public List<ShuntCompensatorNonLinearModel.Section> getAllSections() {
        return Collections.unmodifiableList(this.sections);
    }

    @Override
    public ShuntCompensatorModelType getType() {
        return ShuntCompensatorModelType.NON_LINEAR;
    }

    @Override
    public int getMaximumSectionCount() {
        return this.sections.size();
    }

    @Override
    public double getB(int sectionCount) {
        if (sectionCount < 0 || sectionCount > this.sections.size()) {
            throw new ValidationException((Validable)this.shuntCompensator, "invalid section count (must be in [0;maximumSectionCount]");
        }
        return sectionCount == 0 ? 0.0 : this.sections.get(sectionCount - 1).getB();
    }

    @Override
    public double getG(int sectionCount) {
        if (sectionCount < 0 || sectionCount > this.sections.size()) {
            throw new ValidationException((Validable)this.shuntCompensator, "invalid section count (must be in [0;maximumSectionCount]");
        }
        return sectionCount == 0 ? 0.0 : this.sections.get(sectionCount - 1).getG();
    }

    static class SectionImpl
    implements ShuntCompensatorNonLinearModel.Section {
        private ShuntCompensatorImpl shuntCompensator;
        private final int index;
        private double b;
        private double g;

        SectionImpl(int index, double b, double g) {
            this.index = index;
            this.b = b;
            this.g = g;
        }

        private SectionImpl attach(ShuntCompensatorImpl shuntCompensator) {
            if (this.shuntCompensator != null) {
                throw new IllegalStateException("Section already attached to " + this.shuntCompensator.getId());
            }
            this.shuntCompensator = Objects.requireNonNull(shuntCompensator);
            return this;
        }

        public double getB() {
            return this.b;
        }

        public ShuntCompensatorNonLinearModel.Section setB(double b) {
            ValidationUtil.checkB((Validable)this.shuntCompensator, (double)b);
            double oldValue = this.b;
            this.b = b;
            this.shuntCompensator.notifyUpdate(() -> this.getAttributeName(this.index, "b"), (Object)oldValue, (Object)this.b);
            return this;
        }

        public double getG() {
            return this.g;
        }

        public ShuntCompensatorNonLinearModel.Section setG(double g) {
            ValidationUtil.checkG((Validable)this.shuntCompensator, (double)g);
            double oldValue = this.g;
            this.g = g;
            this.shuntCompensator.notifyUpdate(() -> this.getAttributeName(this.index, "g"), (Object)oldValue, (Object)this.g);
            return this;
        }

        private String getAttributeName(int sectionNum, String attribute) {
            return "section" + sectionNum + "." + attribute;
        }
    }
}

