/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.TerminalExt;
import gnu.trove.list.array.TDoubleArrayList;

class StaticVarCompensatorImpl
extends AbstractConnectable<StaticVarCompensator>
implements StaticVarCompensator {
    static final String TYPE_DESCRIPTION = "staticVarCompensator";
    private double bMin;
    private double bMax;
    private final RegulatingPoint regulatingPoint;
    private final TDoubleArrayList voltageSetpoint;
    private final TDoubleArrayList reactivePowerSetpoint;

    StaticVarCompensatorImpl(String id, String name, boolean fictitious, double bMin, double bMax, double voltageSetpoint, double reactivePowerSetpoint, StaticVarCompensator.RegulationMode regulationMode, TerminalExt regulatingTerminal, Ref<NetworkImpl> ref) {
        super(ref, id, name, fictitious);
        this.bMin = bMin;
        this.bMax = bMax;
        int variantArraySize = ((NetworkImpl)ref.get()).getVariantManager().getVariantArraySize();
        this.voltageSetpoint = new TDoubleArrayList(variantArraySize);
        this.reactivePowerSetpoint = new TDoubleArrayList(variantArraySize);
        this.regulatingPoint = new RegulatingPoint(id, this::getTerminal, variantArraySize, regulationMode != null ? regulationMode.ordinal() : -1, regulationMode == StaticVarCompensator.RegulationMode.VOLTAGE);
        this.regulatingPoint.setRegulatingTerminal(regulatingTerminal);
        for (int i = 0; i < variantArraySize; ++i) {
            this.voltageSetpoint.add(voltageSetpoint);
            this.reactivePowerSetpoint.add(reactivePowerSetpoint);
        }
    }

    public TerminalExt getTerminal() {
        return (TerminalExt)this.terminals.get(0);
    }

    @Override
    protected String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public double getBmin() {
        return this.bMin;
    }

    public StaticVarCompensatorImpl setBmin(double bMin) {
        ValidationUtil.checkBmin((Validable)this, (double)bMin);
        double oldValue = this.bMin;
        this.bMin = bMin;
        this.notifyUpdate("bMin", (Object)oldValue, (Object)bMin);
        return this;
    }

    public double getBmax() {
        return this.bMax;
    }

    public StaticVarCompensatorImpl setBmax(double bMax) {
        ValidationUtil.checkBmax((Validable)this, (double)bMax);
        double oldValue = this.bMax;
        this.bMax = bMax;
        this.notifyUpdate("bMax", (Object)oldValue, (Object)bMax);
        return this;
    }

    public double getVoltageSetpoint() {
        return this.voltageSetpoint.get(this.getNetwork().getVariantIndex());
    }

    public StaticVarCompensatorImpl setVoltageSetpoint(double voltageSetpoint) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkSvcRegulator((Validable)this, (double)voltageSetpoint, (double)this.getReactivePowerSetpoint(), (StaticVarCompensator.RegulationMode)this.getRegulationMode(), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = n.getVariantIndex();
        double oldValue = this.voltageSetpoint.set(variantIndex, voltageSetpoint);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("voltageSetpoint", variantId, (Object)oldValue, (Object)voltageSetpoint);
        return this;
    }

    public double getReactivePowerSetpoint() {
        return this.reactivePowerSetpoint.get(this.getNetwork().getVariantIndex());
    }

    public StaticVarCompensatorImpl setReactivePowerSetpoint(double reactivePowerSetpoint) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkSvcRegulator((Validable)this, (double)this.getVoltageSetpoint(), (double)reactivePowerSetpoint, (StaticVarCompensator.RegulationMode)this.getRegulationMode(), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = n.getVariantIndex();
        double oldValue = this.reactivePowerSetpoint.set(variantIndex, reactivePowerSetpoint);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("reactivePowerSetpoint", variantId, (Object)oldValue, (Object)reactivePowerSetpoint);
        return this;
    }

    public StaticVarCompensator.RegulationMode getRegulationMode() {
        int variantIndex = this.getNetwork().getVariantIndex();
        return this.regulatingPoint.getRegulationMode(variantIndex) != -1 ? StaticVarCompensator.RegulationMode.values()[this.regulatingPoint.getRegulationMode(variantIndex)] : null;
    }

    public StaticVarCompensatorImpl setRegulationMode(StaticVarCompensator.RegulationMode regulationMode) {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkSvcRegulator((Validable)this, (double)this.getVoltageSetpoint(), (double)this.getReactivePowerSetpoint(), (StaticVarCompensator.RegulationMode)regulationMode, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = n.getVariantIndex();
        int oldValueOrdinal = this.regulatingPoint.setRegulationMode(variantIndex, regulationMode != null ? regulationMode.ordinal() : -1);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate("regulationMode", variantId, (Object)(oldValueOrdinal == -1 ? null : StaticVarCompensator.RegulationMode.values()[oldValueOrdinal]), (Object)regulationMode);
        return this;
    }

    public TerminalExt getRegulatingTerminal() {
        return this.regulatingPoint.getRegulatingTerminal();
    }

    public StaticVarCompensatorImpl setRegulatingTerminal(Terminal regulatingTerminal) {
        ValidationUtil.checkRegulatingTerminal((Validable)this, (Terminal)regulatingTerminal, (Network)this.getNetwork());
        TerminalExt oldValue = this.regulatingPoint.getRegulatingTerminal();
        this.regulatingPoint.setRegulatingTerminal((TerminalExt)regulatingTerminal);
        this.notifyUpdate("regulatingTerminal", (Object)oldValue, (Object)this.regulatingPoint.getRegulatingTerminal());
        return this;
    }

    @Override
    public void remove() {
        this.regulatingPoint.remove();
        super.remove();
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.voltageSetpoint.ensureCapacity(this.voltageSetpoint.size() + number);
        this.reactivePowerSetpoint.ensureCapacity(this.reactivePowerSetpoint.size() + number);
        for (int i = 0; i < number; ++i) {
            this.voltageSetpoint.add(this.voltageSetpoint.get(sourceIndex));
            this.reactivePowerSetpoint.add(this.reactivePowerSetpoint.get(sourceIndex));
        }
        this.regulatingPoint.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.voltageSetpoint.remove(this.voltageSetpoint.size() - number, number);
        this.reactivePowerSetpoint.remove(this.reactivePowerSetpoint.size() - number, number);
        this.regulatingPoint.reduceVariantArraySize(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        this.regulatingPoint.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.voltageSetpoint.set(index, this.voltageSetpoint.get(sourceIndex));
            this.reactivePowerSetpoint.set(index, this.reactivePowerSetpoint.get(sourceIndex));
        }
        this.regulatingPoint.allocateVariantArrayElement(indexes, sourceIndex);
    }
}

