/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

class SwitchImpl
extends AbstractIdentifiable<Switch>
implements Switch,
MultiVariantObject {
    private final VoltageLevelExt voltageLevel;
    private final SwitchKind kind;
    private final TBooleanArrayList open;
    private final TBooleanArrayList retained;

    SwitchImpl(VoltageLevelExt voltageLevel, String id, String name, boolean fictitious, SwitchKind kind, boolean open, boolean retained) {
        super(id, name, fictitious);
        this.voltageLevel = voltageLevel;
        this.kind = kind;
        int variantArraySize = voltageLevel.getNetwork().getVariantManager().getVariantArraySize();
        this.open = new TBooleanArrayList(variantArraySize);
        this.retained = new TBooleanArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.open.add(open);
            this.retained.add(retained);
        }
    }

    @Override
    public NetworkImpl getNetwork() {
        return this.voltageLevel.getNetwork();
    }

    public Network getParentNetwork() {
        return this.voltageLevel.getParentNetwork();
    }

    public VoltageLevelExt getVoltageLevel() {
        return this.voltageLevel;
    }

    public SwitchKind getKind() {
        return this.kind;
    }

    public boolean isOpen() {
        return this.open.get(this.getNetwork().getVariantIndex());
    }

    public void setOpen(boolean open) {
        NetworkImpl network = this.getNetwork();
        int index = network.getVariantIndex();
        boolean oldValue = this.open.get(index);
        if (oldValue != open) {
            this.open.set(index, open);
            this.voltageLevel.getTopologyModel().invalidateCache(this.isRetained());
            String variantId = network.getVariantManager().getVariantId(index);
            network.getListeners().notifyUpdate(this, "open", variantId, (Object)oldValue, (Object)open);
        }
    }

    public boolean isRetained() {
        return this.retained.get(this.getNetwork().getVariantIndex());
    }

    public void setRetained(boolean retained) {
        if (this.voltageLevel.getTopologyKind() != TopologyKind.NODE_BREAKER) {
            throw new ValidationException((Validable)this, "retain status is not modifiable in a non node/breaker voltage level");
        }
        NetworkImpl network = this.getNetwork();
        int index = network.getVariantIndex();
        boolean oldValue = this.retained.get(index);
        if (oldValue != retained) {
            this.retained.set(index, retained);
            this.voltageLevel.getTopologyModel().invalidateCache();
            String variantId = network.getVariantManager().getVariantId(index);
            network.getListeners().notifyUpdate(this, "retained", variantId, (Object)oldValue, (Object)retained);
        }
    }

    @Override
    public void setFictitious(boolean fictitious) {
        boolean oldValue = this.fictitious;
        if (oldValue != fictitious) {
            this.fictitious = fictitious;
            this.voltageLevel.getTopologyModel().invalidateCache();
            NetworkImpl network = this.getNetwork();
            network.getListeners().notifyUpdate(this, "fictitious", (Object)oldValue, (Object)fictitious);
        }
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.open.ensureCapacity(this.open.size() + number);
        this.open.fill(initVariantArraySize, initVariantArraySize + number, this.open.get(sourceIndex));
        this.retained.ensureCapacity(this.retained.size() + number);
        this.retained.fill(initVariantArraySize, initVariantArraySize + number, this.retained.get(sourceIndex));
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.open.remove(this.open.size() - number, number);
        this.retained.remove(this.retained.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.open.set(index, this.open.get(sourceIndex));
            this.retained.set(index, this.retained.get(sourceIndex));
        }
    }

    @Override
    protected String getTypeDescription() {
        return "Switch";
    }
}

