/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractConnectableBranch;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerAdderImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerImpl;
import com.powsybl.iidm.network.impl.PhaseTapChangerParent;
import com.powsybl.iidm.network.impl.RatioTapChangerAdderImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerImpl;
import com.powsybl.iidm.network.impl.RatioTapChangerParent;
import com.powsybl.iidm.network.impl.SubstationImpl;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

class TwoWindingsTransformerImpl
extends AbstractConnectableBranch<TwoWindingsTransformer>
implements TwoWindingsTransformer,
RatioTapChangerParent,
PhaseTapChangerParent {
    private final SubstationImpl substation;
    private double r;
    private double x;
    private double g;
    private double b;
    private double ratedU1;
    private double ratedU2;
    private double ratedS;
    private RatioTapChangerImpl ratioTapChanger;
    private PhaseTapChangerImpl phaseTapChanger;

    TwoWindingsTransformerImpl(Ref<NetworkImpl> network, String id, String name, boolean fictitious, SubstationImpl substation, double r, double x, double g, double b, double ratedU1, double ratedU2, double ratedS) {
        super(network, id, name, fictitious);
        this.substation = substation;
        this.r = r;
        this.x = x;
        this.g = g;
        this.b = b;
        this.ratedU1 = ratedU1;
        this.ratedU2 = ratedU2;
        this.ratedS = ratedS;
    }

    public Optional<Substation> getSubstation() {
        return Optional.ofNullable(this.substation);
    }

    public Substation getNullableSubstation() {
        return this.substation;
    }

    public double getR() {
        return this.r;
    }

    public TwoWindingsTransformerImpl setR(double r) {
        ValidationUtil.checkR((Validable)this, (double)r);
        double oldValue = this.r;
        this.r = r;
        this.notifyUpdate("r", (Object)oldValue, (Object)r);
        return this;
    }

    public double getX() {
        return this.x;
    }

    public TwoWindingsTransformerImpl setX(double x) {
        ValidationUtil.checkX((Validable)this, (double)x);
        double oldValue = this.x;
        this.x = x;
        this.notifyUpdate("x", (Object)oldValue, (Object)x);
        return this;
    }

    public double getG() {
        return this.g;
    }

    public TwoWindingsTransformerImpl setG(double g) {
        ValidationUtil.checkG((Validable)this, (double)g);
        double oldValue = this.g;
        this.g = g;
        this.notifyUpdate("g", (Object)oldValue, (Object)g);
        return this;
    }

    public double getB() {
        return this.b;
    }

    public TwoWindingsTransformerImpl setB(double b) {
        ValidationUtil.checkB((Validable)this, (double)b);
        double oldValue = this.b;
        this.b = b;
        this.notifyUpdate("b", (Object)oldValue, (Object)b);
        return this;
    }

    public double getRatedU1() {
        return this.ratedU1;
    }

    public TwoWindingsTransformerImpl setRatedU1(double ratedU1) {
        ValidationUtil.checkRatedU1((Validable)this, (double)ratedU1);
        double oldValue = this.ratedU1;
        this.ratedU1 = ratedU1;
        this.notifyUpdate("ratedU1", (Object)oldValue, (Object)ratedU1);
        return this;
    }

    public double getRatedU2() {
        return this.ratedU2;
    }

    public TwoWindingsTransformerImpl setRatedU2(double ratedU2) {
        ValidationUtil.checkRatedU2((Validable)this, (double)ratedU2);
        double oldValue = this.ratedU2;
        this.ratedU2 = ratedU2;
        this.notifyUpdate("ratedU2", (Object)oldValue, (Object)ratedU2);
        return this;
    }

    public double getRatedS() {
        return this.ratedS;
    }

    public TwoWindingsTransformer setRatedS(double ratedS) {
        ValidationUtil.checkRatedS((Validable)this, (double)ratedS);
        double oldValue = this.ratedS;
        this.ratedS = ratedS;
        this.notifyUpdate("ratedS", (Object)oldValue, (Object)ratedS);
        return this;
    }

    public RatioTapChangerAdderImpl newRatioTapChanger() {
        return new RatioTapChangerAdderImpl(this);
    }

    @Override
    public RatioTapChangerImpl getRatioTapChanger() {
        return this.ratioTapChanger;
    }

    public Optional<RatioTapChanger> getOptionalRatioTapChanger() {
        return Optional.ofNullable(this.ratioTapChanger);
    }

    public PhaseTapChangerAdderImpl newPhaseTapChanger() {
        return new PhaseTapChangerAdderImpl(this);
    }

    @Override
    public PhaseTapChangerImpl getPhaseTapChanger() {
        return this.phaseTapChanger;
    }

    public Optional<PhaseTapChanger> getOptionalPhaseTapChanger() {
        return Optional.ofNullable(this.phaseTapChanger);
    }

    @Override
    public Set<TapChanger<?, ?, ?, ?>> getAllTapChangers() {
        HashSet tapChangers = new HashSet();
        if (this.ratioTapChanger != null) {
            tapChangers.add((TapChanger<?, ?, ?, ?>)this.ratioTapChanger);
        }
        if (this.phaseTapChanger != null) {
            tapChangers.add((TapChanger<?, ?, ?, ?>)this.phaseTapChanger);
        }
        return tapChangers;
    }

    @Override
    public boolean hasRatioTapChanger() {
        return this.ratioTapChanger != null;
    }

    @Override
    public boolean hasPhaseTapChanger() {
        return this.phaseTapChanger != null;
    }

    @Override
    public void setRatioTapChanger(RatioTapChangerImpl ratioTapChanger) {
        RatioTapChangerImpl oldValue = this.ratioTapChanger;
        this.ratioTapChanger = ratioTapChanger;
        this.notifyUpdate("ratioTapChanger", (Object)oldValue, (Object)ratioTapChanger);
    }

    @Override
    public void setPhaseTapChanger(PhaseTapChangerImpl phaseTapChanger) {
        PhaseTapChangerImpl oldValue = this.phaseTapChanger;
        this.phaseTapChanger = phaseTapChanger;
        this.notifyUpdate("phaseTapChanger", (Object)oldValue, (Object)phaseTapChanger);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        if (this.ratioTapChanger != null) {
            this.ratioTapChanger.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        }
        if (this.phaseTapChanger != null) {
            this.phaseTapChanger.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        if (this.ratioTapChanger != null) {
            this.ratioTapChanger.reduceVariantArraySize(number);
        }
        if (this.phaseTapChanger != null) {
            this.phaseTapChanger.reduceVariantArraySize(number);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        if (this.ratioTapChanger != null) {
            this.ratioTapChanger.deleteVariantArrayElement(index);
        }
        if (this.phaseTapChanger != null) {
            this.phaseTapChanger.deleteVariantArrayElement(index);
        }
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        if (this.ratioTapChanger != null) {
            this.ratioTapChanger.allocateVariantArrayElement(indexes, sourceIndex);
        }
        if (this.phaseTapChanger != null) {
            this.phaseTapChanger.allocateVariantArrayElement(indexes, sourceIndex);
        }
    }

    @Override
    public Identifiable getTransformer() {
        return this;
    }

    @Override
    public String getTapChangerAttribute() {
        return "TapChanger";
    }

    @Override
    protected String getTypeDescription() {
        return "2 windings transformer";
    }

    @Override
    public void remove() {
        if (this.ratioTapChanger != null) {
            this.ratioTapChanger.remove();
        }
        if (this.phaseTapChanger != null) {
            this.phaseTapChanger.remove();
        }
        super.remove();
    }
}

