/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ZipLoadModel;
import com.powsybl.iidm.network.impl.AbstractLoadModelImpl;

public class ZipLoadModelImpl
extends AbstractLoadModelImpl
implements ZipLoadModel {
    private double c0p;
    private double c1p;
    private double c2p;
    private double c0q;
    private double c1q;
    private double c2q;

    public ZipLoadModelImpl(double c0p, double c1p, double c2p, double c0q, double c1q, double c2q) {
        this.c0p = c0p;
        this.c1p = c1p;
        this.c2p = c2p;
        this.c0q = c0q;
        this.c1q = c1q;
        this.c2q = c2q;
    }

    static double checkCoefficient(Validable validable, double coefficient) {
        if (Double.isNaN(coefficient)) {
            throw new ValidationException(validable, "Invalid zip load model coefficient: " + coefficient);
        }
        return coefficient;
    }

    public double getC0p() {
        return this.c0p;
    }

    public ZipLoadModelImpl setC0p(double c0p) {
        this.c0p = ZipLoadModelImpl.checkCoefficient(this.load, c0p);
        return this;
    }

    public double getC1p() {
        return this.c1p;
    }

    public ZipLoadModelImpl setC1p(double c1p) {
        this.c1p = ZipLoadModelImpl.checkCoefficient(this.load, c1p);
        return this;
    }

    public double getC2p() {
        return this.c2p;
    }

    public ZipLoadModelImpl setC2p(double c2p) {
        this.c2p = ZipLoadModelImpl.checkCoefficient(this.load, c2p);
        return this;
    }

    public double getC0q() {
        return this.c0q;
    }

    public ZipLoadModelImpl setC0q(double c0q) {
        this.c0q = ZipLoadModelImpl.checkCoefficient(this.load, c0q);
        return this;
    }

    public double getC1q() {
        return this.c1q;
    }

    public ZipLoadModelImpl setC1q(double c1q) {
        this.c1q = ZipLoadModelImpl.checkCoefficient(this.load, c1q);
        return this;
    }

    public double getC2q() {
        return this.c2q;
    }

    public ZipLoadModelImpl setC2q(double c2q) {
        this.c2q = ZipLoadModelImpl.checkCoefficient(this.load, c2q);
        return this;
    }
}

