/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.util.trove.TBooleanArrayList;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.extensions.ActivePowerControl;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import com.powsybl.iidm.network.impl.NetworkImpl;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.List;
import java.util.OptionalDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivePowerControlImpl<T extends Injection<T>>
extends AbstractMultiVariantIdentifiableExtension<T>
implements ActivePowerControl<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivePowerControlImpl.class);
    private final TBooleanArrayList participate;
    private final TDoubleArrayList droop;
    private final TDoubleArrayList participationFactor;
    private final TDoubleArrayList minTargetP;
    private final TDoubleArrayList maxTargetP;
    private final List<TDoubleArrayList> allTDoubleArrayLists;

    public ActivePowerControlImpl(T component, boolean participate, double droop, double participationFactor) {
        this(component, participate, droop, participationFactor, Double.NaN, Double.NaN);
    }

    public ActivePowerControlImpl(T component, boolean participate, double droop, double participationFactor, double minTargetP, double maxTargetP) {
        super(component);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.participate = new TBooleanArrayList(variantArraySize);
        this.droop = new TDoubleArrayList(variantArraySize);
        this.participationFactor = new TDoubleArrayList(variantArraySize);
        this.minTargetP = new TDoubleArrayList(variantArraySize);
        this.maxTargetP = new TDoubleArrayList(variantArraySize);
        this.allTDoubleArrayLists = List.of(this.droop, this.participationFactor, this.minTargetP, this.maxTargetP);
        double checkedMinTargetP = this.checkTargetPLimit(minTargetP, "minTargetP", component);
        double checkedMaxTargetP = this.checkTargetPLimit(maxTargetP, "maxTargetP", component);
        for (int i = 0; i < variantArraySize; ++i) {
            this.participate.add(participate);
            this.droop.add(droop);
            this.participationFactor.add(participationFactor);
            this.minTargetP.add(checkedMinTargetP);
            this.maxTargetP.add(checkedMaxTargetP);
        }
        this.checkLimitOrder(minTargetP, maxTargetP);
    }

    private PLimits getPLimits(T injection) {
        double maxP = Double.MAX_VALUE;
        double minP = -1.7976931348623157E308;
        if (injection instanceof Generator) {
            Generator generator = (Generator)injection;
            maxP = generator.getMaxP();
            minP = generator.getMinP();
        } else if (injection instanceof Battery) {
            Battery battery = (Battery)injection;
            maxP = battery.getMaxP();
            minP = battery.getMinP();
        }
        return new PLimits(minP, maxP);
    }

    private double withinPMinMax(double value, T injection) {
        PLimits pLimits = this.getPLimits(injection);
        if (!Double.isNaN(value) && (value < pLimits.minP || value > pLimits.maxP)) {
            LOGGER.warn("targetP limit is now outside of pMin,pMax for component {}. Returning closest value in [pmin,pMax].", (Object)injection.getId());
            return value < pLimits.minP ? pLimits.minP : pLimits.maxP;
        }
        return value;
    }

    private double checkTargetPLimit(double targetPLimit, String name, T injection) {
        PLimits pLimits = this.getPLimits(injection);
        if (!Double.isNaN(targetPLimit) && (targetPLimit < pLimits.minP || targetPLimit > pLimits.maxP)) {
            throw new PowsyblException(String.format("%s value (%s) is not between minP and maxP for component %s", name, targetPLimit, injection.getId()));
        }
        return targetPLimit;
    }

    private void checkLimitOrder(double minTargetP, double maxTargetP) {
        if (!Double.isNaN(minTargetP) && !Double.isNaN(maxTargetP) && minTargetP > maxTargetP) {
            throw new PowsyblException("invalid targetP limits [" + minTargetP + ", " + maxTargetP + "]");
        }
    }

    public boolean isParticipate() {
        return this.participate.get(this.getVariantIndex());
    }

    public void setParticipate(boolean participate) {
        int variantIndex = this.getVariantIndex();
        boolean oldParticipate = this.participate.get(variantIndex);
        if (oldParticipate != participate) {
            this.participate.set(variantIndex, participate);
            NetworkImpl network = (NetworkImpl)((Injection)this.getExtendable()).getNetwork();
            String variantId = this.getVariantManagerHolder().getVariantManager().getWorkingVariantId();
            network.getListeners().notifyExtensionUpdate((Extension<?>)this, "participate", variantId, oldParticipate, participate);
        }
    }

    public double getDroop() {
        return this.droop.get(this.getVariantIndex());
    }

    public void setDroop(double droop) {
        int variantIndex = this.getVariantIndex();
        double oldDroop = this.droop.get(variantIndex);
        if (oldDroop != droop) {
            this.droop.set(variantIndex, droop);
            NetworkImpl network = (NetworkImpl)((Injection)this.getExtendable()).getNetwork();
            String variantId = this.getVariantManagerHolder().getVariantManager().getWorkingVariantId();
            network.getListeners().notifyExtensionUpdate((Extension<?>)this, "droop", variantId, oldDroop, droop);
        }
    }

    public double getParticipationFactor() {
        return this.participationFactor.get(this.getVariantIndex());
    }

    public void setParticipationFactor(double participationFactor) {
        this.participationFactor.set(this.getVariantIndex(), participationFactor);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.participate.ensureCapacity(this.participate.size() + number);
        this.allTDoubleArrayLists.forEach(dl -> dl.ensureCapacity(dl.size() + number));
        for (int i = 0; i < number; ++i) {
            this.participate.add(this.participate.get(sourceIndex));
            this.allTDoubleArrayLists.forEach(dl -> dl.add(dl.get(sourceIndex)));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.participate.remove(this.participate.size() - number, number);
        this.allTDoubleArrayLists.forEach(dl -> dl.remove(dl.size() - number, number));
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.participate.set(index, this.participate.get(sourceIndex));
            this.allTDoubleArrayLists.forEach(dl -> dl.set(index, dl.get(sourceIndex)));
        }
    }

    public OptionalDouble getMinTargetP() {
        double result = this.minTargetP.get(this.getVariantIndex());
        return Double.isNaN(result) ? OptionalDouble.empty() : OptionalDouble.of(this.withinPMinMax(result, (Injection)this.getExtendable()));
    }

    public void setMinTargetP(double minTargetP) {
        this.checkLimitOrder(minTargetP, this.maxTargetP.get(this.getVariantIndex()));
        this.minTargetP.set(this.getVariantIndex(), this.checkTargetPLimit(minTargetP, "minTargetP", (Injection)this.getExtendable()));
    }

    public OptionalDouble getMaxTargetP() {
        double result = this.maxTargetP.get(this.getVariantIndex());
        return Double.isNaN(result) ? OptionalDouble.empty() : OptionalDouble.of(this.withinPMinMax(result, (Injection)this.getExtendable()));
    }

    public void setMaxTargetP(double maxTargetP) {
        this.checkLimitOrder(this.minTargetP.get(this.getVariantIndex()), maxTargetP);
        this.maxTargetP.set(this.getVariantIndex(), this.checkTargetPLimit(maxTargetP, "maxTargetP", (Injection)this.getExtendable()));
    }

    record PLimits(double minP, double maxP) {
    }
}

