/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.extensions.AbstractExtension;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.extensions.BranchObservability;
import com.powsybl.iidm.network.extensions.ObservabilityQuality;
import com.powsybl.iidm.network.impl.extensions.ObservabilityQualityImpl;

public class BranchObservabilityImpl<B extends Branch<B>>
extends AbstractExtension<B>
implements BranchObservability<B> {
    private boolean observable;
    private ObservabilityQuality<B> qualityP1;
    private ObservabilityQuality<B> qualityP2;
    private ObservabilityQuality<B> qualityQ1;
    private ObservabilityQuality<B> qualityQ2;

    public BranchObservabilityImpl(B component, boolean observable) {
        super(component);
        this.observable = observable;
    }

    public BranchObservabilityImpl(B component, boolean observable, double standardDeviationP1, Boolean redundantP1, double standardDeviationP2, Boolean redundantP2, double standardDeviationQ1, Boolean redundantQ1, double standardDeviationQ2, Boolean redundantQ2) {
        this(component, observable);
        this.qualityP1 = new ObservabilityQualityImpl<B>(standardDeviationP1, redundantP1);
        this.qualityP2 = new ObservabilityQualityImpl<B>(standardDeviationP2, redundantP2);
        this.qualityQ1 = new ObservabilityQualityImpl<B>(standardDeviationQ1, redundantQ1);
        this.qualityQ2 = new ObservabilityQualityImpl<B>(standardDeviationQ2, redundantQ2);
    }

    public boolean isObservable() {
        return this.observable;
    }

    public BranchObservability<B> setObservable(boolean observable) {
        this.observable = observable;
        return this;
    }

    public ObservabilityQuality<B> getQualityP1() {
        return this.qualityP1;
    }

    public BranchObservability<B> setQualityP1(double standardDeviation, Boolean redundant) {
        if (this.qualityP1 == null) {
            this.qualityP1 = new ObservabilityQualityImpl<B>(standardDeviation, redundant);
        } else {
            this.qualityP1.setStandardDeviation(standardDeviation);
            this.qualityP1.setRedundant(redundant);
        }
        return this;
    }

    public BranchObservability<B> setQualityP1(double standardDeviation) {
        if (this.qualityP1 == null) {
            this.qualityP1 = new ObservabilityQualityImpl<B>(standardDeviation);
        } else {
            this.qualityP1.setStandardDeviation(standardDeviation);
        }
        return this;
    }

    public ObservabilityQuality<B> getQualityP2() {
        return this.qualityP2;
    }

    public BranchObservability<B> setQualityP2(double standardDeviation, Boolean redundant) {
        if (this.qualityP2 == null) {
            this.qualityP2 = new ObservabilityQualityImpl<B>(standardDeviation, redundant);
        } else {
            this.qualityP2.setStandardDeviation(standardDeviation);
            this.qualityP2.setRedundant(redundant);
        }
        return this;
    }

    public BranchObservability<B> setQualityP2(double standardDeviation) {
        if (this.qualityP2 == null) {
            this.qualityP2 = new ObservabilityQualityImpl<B>(standardDeviation);
        } else {
            this.qualityP2.setStandardDeviation(standardDeviation);
        }
        return this;
    }

    public ObservabilityQuality<B> getQualityQ1() {
        return this.qualityQ1;
    }

    public BranchObservability<B> setQualityQ1(double standardDeviation, Boolean redundant) {
        if (this.qualityQ1 == null) {
            this.qualityQ1 = new ObservabilityQualityImpl<B>(standardDeviation, redundant);
        } else {
            this.qualityQ1.setStandardDeviation(standardDeviation);
            this.qualityQ1.setRedundant(redundant);
        }
        return this;
    }

    public BranchObservability<B> setQualityQ1(double standardDeviation) {
        if (this.qualityQ1 == null) {
            this.qualityQ1 = new ObservabilityQualityImpl<B>(standardDeviation);
        } else {
            this.qualityQ1.setStandardDeviation(standardDeviation);
        }
        return this;
    }

    public ObservabilityQuality<B> getQualityQ2() {
        return this.qualityQ2;
    }

    public BranchObservability<B> setQualityQ2(double standardDeviation, Boolean redundant) {
        if (this.qualityQ2 == null) {
            this.qualityQ2 = new ObservabilityQualityImpl<B>(standardDeviation, redundant);
        } else {
            this.qualityQ2.setStandardDeviation(standardDeviation);
            this.qualityQ2.setRedundant(redundant);
        }
        return this;
    }

    public BranchObservability<B> setQualityQ2(double standardDeviation) {
        if (this.qualityQ2 == null) {
            this.qualityQ2 = new ObservabilityQualityImpl<B>(standardDeviation);
        } else {
            this.qualityQ2.setStandardDeviation(standardDeviation);
        }
        return this;
    }
}

