/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.extensions.LoadDetail;
import com.powsybl.iidm.network.impl.AbstractMultiVariantIdentifiableExtension;
import gnu.trove.list.array.TDoubleArrayList;

public class LoadDetailImpl
extends AbstractMultiVariantIdentifiableExtension<Load>
implements LoadDetail {
    private final TDoubleArrayList fixedActivePower;
    private final TDoubleArrayList fixedReactivePower;
    private final TDoubleArrayList variableActivePower;
    private final TDoubleArrayList variableReactivePower;

    public LoadDetailImpl(Load load, double fixedActivePower, double fixedReactivePower, double variableActivePower, double variableReactivePower) {
        super(load);
        int variantArraySize = this.getVariantManagerHolder().getVariantManager().getVariantArraySize();
        this.fixedActivePower = new TDoubleArrayList(variantArraySize);
        this.fixedReactivePower = new TDoubleArrayList(variantArraySize);
        this.variableActivePower = new TDoubleArrayList(variantArraySize);
        this.variableReactivePower = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.fixedActivePower.add(LoadDetailImpl.checkPower(fixedActivePower, "Invalid fixedActivePower", load));
            this.fixedReactivePower.add(LoadDetailImpl.checkPower(fixedReactivePower, "Invalid fixedReactivePower", load));
            this.variableActivePower.add(LoadDetailImpl.checkPower(variableActivePower, "Invalid variableActivePower", load));
            this.variableReactivePower.add(LoadDetailImpl.checkPower(variableReactivePower, "Invalid variableReactivePower", load));
        }
    }

    public double getFixedActivePower() {
        return this.fixedActivePower.get(this.getVariantIndex());
    }

    public LoadDetail setFixedActivePower(double fixedActivePower) {
        LoadDetailImpl.checkPower(fixedActivePower, "Invalid fixedActivePower", (Load)this.getExtendable());
        this.fixedActivePower.set(this.getVariantIndex(), fixedActivePower);
        return this;
    }

    public double getFixedReactivePower() {
        return this.fixedReactivePower.get(this.getVariantIndex());
    }

    public LoadDetail setFixedReactivePower(double fixedReactivePower) {
        LoadDetailImpl.checkPower(fixedReactivePower, "Invalid fixedReactivePower", (Load)this.getExtendable());
        this.fixedReactivePower.set(this.getVariantIndex(), fixedReactivePower);
        return this;
    }

    public double getVariableActivePower() {
        return this.variableActivePower.get(this.getVariantIndex());
    }

    public LoadDetail setVariableActivePower(double variableActivePower) {
        LoadDetailImpl.checkPower(variableActivePower, "Invalid variableActivePower", (Load)this.getExtendable());
        this.variableActivePower.set(this.getVariantIndex(), variableActivePower);
        return this;
    }

    public double getVariableReactivePower() {
        return this.variableReactivePower.get(this.getVariantIndex());
    }

    public LoadDetail setVariableReactivePower(double variableReactivePower) {
        LoadDetailImpl.checkPower(variableReactivePower, "Invalid variableReactivePower", (Load)this.getExtendable());
        this.variableReactivePower.set(this.getVariantIndex(), variableReactivePower);
        return this;
    }

    private static double checkPower(double power, String errorMessage, Load load) {
        if (Double.isNaN(power)) {
            throw new IllegalArgumentException(String.format("%s (%s) for load %s", errorMessage, power, load.getId()));
        }
        return power;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.fixedActivePower.ensureCapacity(this.fixedActivePower.size() + number);
        this.fixedReactivePower.ensureCapacity(this.fixedReactivePower.size() + number);
        this.variableActivePower.ensureCapacity(this.variableActivePower.size() + number);
        this.variableReactivePower.ensureCapacity(this.variableReactivePower.size() + number);
        for (int i = 0; i < number; ++i) {
            this.fixedActivePower.add(this.fixedActivePower.get(sourceIndex));
            this.fixedReactivePower.add(this.fixedReactivePower.get(sourceIndex));
            this.variableActivePower.add(this.variableActivePower.get(sourceIndex));
            this.variableReactivePower.add(this.variableReactivePower.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.fixedActivePower.remove(this.fixedActivePower.size() - number, number);
        this.fixedReactivePower.remove(this.fixedReactivePower.size() - number, number);
        this.variableActivePower.remove(this.variableActivePower.size() - number, number);
        this.variableReactivePower.remove(this.variableReactivePower.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.fixedActivePower.set(index, this.fixedActivePower.get(sourceIndex));
            this.fixedReactivePower.set(index, this.fixedReactivePower.get(sourceIndex));
            this.variableActivePower.set(index, this.variableActivePower.get(sourceIndex));
            this.variableReactivePower.set(index, this.variableReactivePower.get(sourceIndex));
        }
    }
}

