/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.extensions.PilotPoint;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.extensions.ControlZoneImpl;
import com.powsybl.iidm.network.impl.extensions.SecondaryVoltageControlImpl;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class PilotPointImpl
implements PilotPoint {
    private final List<String> busbarSectionsOrBusesIds;
    private double targetV;
    private ControlZoneImpl controlZone;

    PilotPointImpl(List<String> busbarSectionsOrBusesIds, double targetV) {
        this.busbarSectionsOrBusesIds = Objects.requireNonNull(busbarSectionsOrBusesIds);
        this.targetV = targetV;
    }

    public void setControlZone(ControlZoneImpl controlZone) {
        this.controlZone = Objects.requireNonNull(controlZone);
    }

    public List<String> getBusbarSectionsOrBusesIds() {
        return Collections.unmodifiableList(this.busbarSectionsOrBusesIds);
    }

    public double getTargetV() {
        return this.targetV;
    }

    public void setTargetV(double targetV) {
        if (Double.isNaN(targetV)) {
            throw new PowsyblException("Invalid pilot point target voltage for zone '" + this.controlZone.getName() + "'");
        }
        if (targetV != this.targetV) {
            double oldTargetV = this.targetV;
            this.targetV = targetV;
            SecondaryVoltageControlImpl secondaryVoltageControl = this.controlZone.getSecondaryVoltageControl();
            NetworkImpl network = (NetworkImpl)secondaryVoltageControl.getExtendable();
            network.getListeners().notifyExtensionUpdate((Extension<?>)secondaryVoltageControl, "pilotPointTargetV", null, new PilotPoint.TargetVoltageEvent(this.controlZone.getName(), oldTargetV), new PilotPoint.TargetVoltageEvent(this.controlZone.getName(), targetV));
        }
    }
}

