/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.DcTerminal;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TerminalNumber;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.DcTerminalImpl;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.TerminalExt;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

abstract class AbstractAcDcConverter<I extends AcDcConverter<I>>
extends AbstractConnectable<I>
implements AcDcConverter<I>,
MultiVariantObject {
    public static final String IDLE_LOSS = "idleLoss";
    public static final String SWITCHING_LOSS = "switchingLoss";
    public static final String RESISTIVE_LOSS = "resistiveLoss";
    public static final String PCC_TERMINAL = "pccTerminal";
    public static final String CONTROL_MODE = "controlMode";
    public static final String TARGET_P = "targetP";
    public static final String TARGET_VDC = "targetVdc";
    protected final List<DcTerminalImpl> dcTerminals = new ArrayList<DcTerminalImpl>();
    private double idleLoss;
    private double switchingLoss;
    private double resistiveLoss;
    private final RegulatingPoint pccRegulatingPoint;
    private final TDoubleArrayList targetP;
    private final TDoubleArrayList targetVdc;

    AbstractAcDcConverter(Ref<NetworkImpl> ref, String id, String name, boolean fictitious, double idleLoss, double switchingLoss, double resistiveLoss, TerminalExt pccTerminal, AcDcConverter.ControlMode controlMode, double targetP, double targetVdc) {
        super(ref, id, name, fictitious);
        this.idleLoss = idleLoss;
        this.switchingLoss = switchingLoss;
        this.resistiveLoss = resistiveLoss;
        int variantArraySize = ((NetworkImpl)ref.get()).getVariantManager().getVariantArraySize();
        this.targetP = new TDoubleArrayList(variantArraySize);
        this.targetVdc = new TDoubleArrayList(variantArraySize);
        this.pccRegulatingPoint = new RegulatingPoint(id, () -> null, variantArraySize, controlMode.ordinal(), AcDcConverter.ControlMode.V_DC.ordinal(), false);
        this.pccRegulatingPoint.setRegulatingTerminal(pccTerminal);
        for (int i = 0; i < variantArraySize; ++i) {
            this.targetP.add(targetP);
            this.targetVdc.add(targetVdc);
        }
    }

    public Terminal getTerminal1() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"terminal1");
        return this.getTerminals().get(0);
    }

    public Optional<Terminal> getTerminal2() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"terminal2");
        if (this.terminals.size() > 1) {
            return Optional.of((Terminal)this.terminals.get(1));
        }
        return Optional.empty();
    }

    public TerminalNumber getTerminalNumber(Terminal terminal) {
        Objects.requireNonNull(terminal);
        if (this.getTerminal1() == terminal) {
            return TerminalNumber.ONE;
        }
        if (this.getTerminal2().orElse(null) == terminal) {
            return TerminalNumber.TWO;
        }
        throw new IllegalStateException("The terminal is not connected to this AC/DC converter");
    }

    public Optional<Terminal> getTerminal(TerminalNumber terminalNumber) {
        Objects.requireNonNull(terminalNumber);
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"terminal");
        if (terminalNumber == TerminalNumber.ONE) {
            return Optional.of(this.getTerminal1());
        }
        if (terminalNumber == TerminalNumber.TWO) {
            return this.getTerminal2();
        }
        throw new IllegalStateException("Unexpected AC terminal number: " + String.valueOf(terminalNumber));
    }

    public DcTerminal getDcTerminal1() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"dcTerminal1");
        return this.dcTerminals.get(0);
    }

    public DcTerminal getDcTerminal2() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"dcTerminal2");
        return this.dcTerminals.get(1);
    }

    public TerminalNumber getTerminalNumber(DcTerminal dcTerminal) {
        Objects.requireNonNull(dcTerminal);
        if (this.getDcTerminal1() == dcTerminal) {
            return TerminalNumber.ONE;
        }
        if (this.getDcTerminal2() == dcTerminal) {
            return TerminalNumber.TWO;
        }
        throw new IllegalStateException("The DC terminal is not connected to this AC/DC converter");
    }

    public DcTerminal getDcTerminal(TerminalNumber terminalNumber) {
        Objects.requireNonNull(terminalNumber);
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"terminal");
        if (terminalNumber == TerminalNumber.ONE) {
            return this.dcTerminals.get(0);
        }
        if (terminalNumber == TerminalNumber.TWO) {
            return this.dcTerminals.get(1);
        }
        throw new IllegalStateException("Unexpected DC terminal number: " + String.valueOf(terminalNumber));
    }

    public List<DcTerminal> getDcTerminals() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"dcTerminals");
        return List.copyOf(this.dcTerminals);
    }

    void addDcTerminal(DcTerminalImpl dcTerminal) {
        this.dcTerminals.add(dcTerminal);
        dcTerminal.setDcConnectable(this);
    }

    public double getIdleLoss() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)IDLE_LOSS);
        return this.idleLoss;
    }

    public I setIdleLoss(double idleLoss) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)IDLE_LOSS);
        ValidationUtil.checkDoubleParamPositive((Validable)this, (double)idleLoss, (String)IDLE_LOSS);
        double oldValue = this.idleLoss;
        this.idleLoss = idleLoss;
        this.getNetwork().getListeners().notifyUpdate(this, IDLE_LOSS, (Object)oldValue, (Object)idleLoss);
        return this.self();
    }

    public double getSwitchingLoss() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)SWITCHING_LOSS);
        return this.switchingLoss;
    }

    public I setSwitchingLoss(double switchingLoss) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)SWITCHING_LOSS);
        ValidationUtil.checkDoubleParamPositive((Validable)this, (double)switchingLoss, (String)SWITCHING_LOSS);
        double oldValue = this.switchingLoss;
        this.switchingLoss = switchingLoss;
        this.getNetwork().getListeners().notifyUpdate(this, SWITCHING_LOSS, (Object)oldValue, (Object)switchingLoss);
        return this.self();
    }

    public double getResistiveLoss() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)RESISTIVE_LOSS);
        return this.resistiveLoss;
    }

    public I setResistiveLoss(double resistiveLoss) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)RESISTIVE_LOSS);
        ValidationUtil.checkDoubleParamPositive((Validable)this, (double)resistiveLoss, (String)RESISTIVE_LOSS);
        double oldValue = this.resistiveLoss;
        this.resistiveLoss = resistiveLoss;
        this.getNetwork().getListeners().notifyUpdate(this, RESISTIVE_LOSS, (Object)oldValue, (Object)resistiveLoss);
        return this.self();
    }

    public I setPccTerminal(Terminal pccTerminal) {
        Objects.requireNonNull(pccTerminal);
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)PCC_TERMINAL);
        ValidationUtil.checkAcDcConverterPccTerminal((Validable)this, (boolean)this.getTerminal2().isPresent(), (Terminal)pccTerminal, (VoltageLevel)this.getTerminal1().getVoltageLevel());
        TerminalExt oldValue = this.pccRegulatingPoint.getRegulatingTerminal();
        this.pccRegulatingPoint.setRegulatingTerminal((TerminalExt)pccTerminal);
        this.notifyUpdate(PCC_TERMINAL, (Object)oldValue, (Object)this.pccRegulatingPoint.getRegulatingTerminal());
        return this.self();
    }

    public Terminal getPccTerminal() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)PCC_TERMINAL);
        return this.pccRegulatingPoint.getRegulatingTerminal();
    }

    public I setControlMode(AcDcConverter.ControlMode controlMode) {
        Objects.requireNonNull(controlMode);
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)CONTROL_MODE);
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkAcDcConverterControl((Validable)this, (AcDcConverter.ControlMode)controlMode, (double)this.getTargetP(), (double)this.getTargetVdc(), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = n.getVariantIndex();
        int oldValueOrdinal = this.pccRegulatingPoint.setRegulationMode(variantIndex, controlMode.ordinal());
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        this.notifyUpdate(CONTROL_MODE, variantId, (Object)AcDcConverter.ControlMode.values()[oldValueOrdinal], (Object)controlMode);
        return this.self();
    }

    public AcDcConverter.ControlMode getControlMode() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)CONTROL_MODE);
        int variantIndex = this.getNetwork().getVariantIndex();
        return AcDcConverter.ControlMode.values()[this.pccRegulatingPoint.getRegulationMode(variantIndex)];
    }

    public I setTargetP(double targetP) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)TARGET_P);
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkAcDcConverterControl((Validable)this, (AcDcConverter.ControlMode)this.getControlMode(), (double)targetP, (double)this.getTargetVdc(), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = n.getVariantIndex();
        double oldValue = this.targetP.set(variantIndex, targetP);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate(TARGET_P, variantId, (Object)oldValue, (Object)targetP);
        return this.self();
    }

    public double getTargetP() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)TARGET_P);
        return this.targetP.get(this.getNetwork().getVariantIndex());
    }

    public I setTargetVdc(double targetVdc) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)TARGET_VDC);
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkAcDcConverterControl((Validable)this, (AcDcConverter.ControlMode)this.getControlMode(), (double)this.getTargetP(), (double)targetVdc, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        int variantIndex = n.getVariantIndex();
        double oldValue = this.targetVdc.set(variantIndex, targetVdc);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.notifyUpdate(TARGET_VDC, variantId, (Object)oldValue, (Object)targetVdc);
        return this.self();
    }

    public double getTargetVdc() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)TARGET_VDC);
        return this.targetVdc.get(this.getNetwork().getVariantIndex());
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        this.targetP.ensureCapacity(this.targetP.size() + number);
        this.targetVdc.ensureCapacity(this.targetVdc.size() + number);
        for (int i = 0; i < number; ++i) {
            this.targetP.add(this.targetP.get(sourceIndex));
            this.targetVdc.add(this.targetVdc.get(sourceIndex));
        }
        for (DcTerminalImpl t : this.dcTerminals) {
            t.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        }
        this.pccRegulatingPoint.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        this.targetP.remove(this.targetP.size() - number, number);
        this.targetVdc.remove(this.targetVdc.size() - number, number);
        for (DcTerminalImpl t : this.dcTerminals) {
            t.reduceVariantArraySize(number);
        }
        this.pccRegulatingPoint.reduceVariantArraySize(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        for (DcTerminalImpl t : this.dcTerminals) {
            t.deleteVariantArrayElement(index);
        }
        this.pccRegulatingPoint.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (int index : indexes) {
            this.targetP.set(index, this.targetP.get(sourceIndex));
            this.targetVdc.set(index, this.targetVdc.get(sourceIndex));
        }
        Object object = this.dcTerminals.iterator();
        while (object.hasNext()) {
            DcTerminalImpl t = (DcTerminalImpl)object.next();
            t.allocateVariantArrayElement(indexes, sourceIndex);
        }
        this.pccRegulatingPoint.allocateVariantArrayElement(indexes, sourceIndex);
    }

    @Override
    public void remove() {
        this.dcTerminals.forEach(dcTerminal -> {
            ((AbstractNetwork)this.getParentNetwork()).getDcTopologyModel().detach((DcTerminalImpl)dcTerminal);
            dcTerminal.remove();
        });
        this.pccRegulatingPoint.remove();
        super.remove();
    }

    protected abstract I self();
}

