/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TerminalNumber;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.impl.AbstractAcDcConverter;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.DcTerminalImpl;
import com.powsybl.iidm.network.impl.DcTopologyModel;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TerminalBuilder;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import java.util.Objects;
import java.util.Optional;

abstract class AbstractAcDcConverterAdder<T extends AbstractAcDcConverterAdder<T>>
extends AbstractIdentifiableAdder<T> {
    protected String dcNode1Id;
    protected boolean dcConnected1 = true;
    protected String dcNode2Id;
    protected boolean dcConnected2 = true;
    private Integer node1;
    private String bus1;
    private String connectableBus1;
    protected VoltageLevelExt voltageLevel;
    private Integer node2;
    private String bus2;
    private String connectableBus2;
    protected double idleLoss = 0.0;
    protected double switchingLoss = 0.0;
    protected double resistiveLoss = 0.0;
    protected TerminalExt pccTerminal;
    protected AcDcConverter.ControlMode controlMode;
    protected double targetP = Double.NaN;
    protected double targetVdc = Double.NaN;

    AbstractAcDcConverterAdder(VoltageLevelExt voltageLevel) {
        this.voltageLevel = voltageLevel;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.voltageLevel.getNetwork();
    }

    public T setDcNode1(String dcNode1) {
        this.dcNode1Id = Objects.requireNonNull(dcNode1);
        return this.self();
    }

    public T setDcConnected1(boolean dcConnected1) {
        this.dcConnected1 = dcConnected1;
        return this.self();
    }

    public T setDcNode2(String dcNode2) {
        this.dcNode2Id = Objects.requireNonNull(dcNode2);
        return this.self();
    }

    public T setDcConnected2(boolean dcConnected2) {
        this.dcConnected2 = dcConnected2;
        return this.self();
    }

    public T setNode1(int node1) {
        this.node1 = node1;
        return this.self();
    }

    public T setBus1(String bus1) {
        this.bus1 = bus1;
        return this.self();
    }

    public T setConnectableBus1(String connectableBus1) {
        this.connectableBus1 = connectableBus1;
        return this.self();
    }

    protected TerminalExt checkAndGetTerminal1() {
        return new TerminalBuilder(this.voltageLevel.getNetworkRef(), this, null, TerminalNumber.ONE).setNode(this.node1).setBus(this.bus1).setConnectableBus(this.connectableBus1).build();
    }

    public T setNode2(int node2) {
        this.node2 = node2;
        return this.self();
    }

    public T setBus2(String bus2) {
        this.bus2 = bus2;
        return this.self();
    }

    public T setConnectableBus2(String connectableBus2) {
        this.connectableBus2 = connectableBus2;
        return this.self();
    }

    protected Optional<TerminalExt> checkAndGetTerminal2() {
        if (this.hasTwoAcTerminals()) {
            return Optional.of(new TerminalBuilder(this.voltageLevel.getNetworkRef(), this, null, TerminalNumber.TWO).setNode(this.node2).setBus(this.bus2).setConnectableBus(this.connectableBus2).build());
        }
        return Optional.empty();
    }

    public T setIdleLoss(double idleLoss) {
        this.idleLoss = idleLoss;
        return this.self();
    }

    public T setSwitchingLoss(double switchingLoss) {
        this.switchingLoss = switchingLoss;
        return this.self();
    }

    public T setResistiveLoss(double resistiveLoss) {
        this.resistiveLoss = resistiveLoss;
        return this.self();
    }

    public T setPccTerminal(Terminal pccTerminal) {
        this.pccTerminal = (TerminalExt)pccTerminal;
        return this.self();
    }

    public T setControlMode(AcDcConverter.ControlMode controlMode) {
        this.controlMode = controlMode;
        return this.self();
    }

    public T setTargetP(double targetP) {
        this.targetP = targetP;
        return this.self();
    }

    public T setTargetVdc(double targetVdc) {
        this.targetVdc = targetVdc;
        return this.self();
    }

    protected void preCheck() {
        NetworkImpl network = this.getNetwork();
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkAcDcConverterControl((Validable)this, (AcDcConverter.ControlMode)this.controlMode, (double)this.targetP, (double)this.targetVdc, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        ValidationUtil.checkAcDcConverterPccTerminal((Validable)this, (boolean)this.hasTwoAcTerminals(), (Terminal)this.pccTerminal, (VoltageLevel)this.voltageLevel);
    }

    private boolean hasTwoAcTerminals() {
        return this.bus2 != null || this.connectableBus2 != null || this.node2 != null;
    }

    protected void checkAndAdd(AbstractAcDcConverter<?> dcConverter) {
        TerminalExt terminal1 = this.checkAndGetTerminal1();
        DcNode dcNode1 = ValidationUtil.checkAndGetDcNode((Network)this.getNetwork().getParentNetwork(), (Validable)this, (String)this.dcNode1Id, (String)"dcNode1");
        DcNode dcNode2 = ValidationUtil.checkAndGetDcNode((Network)this.getNetwork().getParentNetwork(), (Validable)this, (String)this.dcNode2Id, (String)"dcNode2");
        ValidationUtil.checkSameParentNetwork((Network)this.voltageLevel.getParentNetwork(), (Validable)this, (DcNode)dcNode1, (DcNode)dcNode2);
        Optional<TerminalExt> terminal2 = this.checkAndGetTerminal2();
        dcConverter.addTerminal(terminal1);
        this.voltageLevel.getTopologyModel().attach(terminal1, false);
        if (this.pccTerminal == null && terminal2.isEmpty()) {
            dcConverter.setPccTerminal(terminal1);
        }
        terminal2.ifPresent(terminal -> {
            dcConverter.addTerminal((TerminalExt)terminal);
            this.voltageLevel.getTopologyModel().attach((TerminalExt)terminal, false);
        });
        DcTerminalImpl dcTerminal1 = new DcTerminalImpl(this.voltageLevel.getNetworkRef(), null, TerminalNumber.ONE, dcNode1, this.dcConnected1);
        DcTerminalImpl dcTerminal2 = new DcTerminalImpl(this.voltageLevel.getNetworkRef(), null, TerminalNumber.TWO, dcNode2, this.dcConnected2);
        dcConverter.addDcTerminal(dcTerminal1);
        dcConverter.addDcTerminal(dcTerminal2);
        DcTopologyModel dcTopologyModel = ((AbstractNetwork)this.voltageLevel.getParentNetwork()).getDcTopologyModel();
        dcTopologyModel.attach(dcTerminal1);
        dcTopologyModel.attach(dcTerminal2);
        this.getNetwork().getIndex().checkAndAdd(dcConverter);
        this.getNetwork().getListeners().notifyCreation(dcConverter);
    }

    protected abstract T self();
}

