/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.TerminalBuilder;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

abstract class AbstractBranchAdder<T extends AbstractBranchAdder<T>>
extends AbstractIdentifiableAdder<T> {
    private Integer node1;
    private String bus1;
    private String connectableBus1;
    private String voltageLevelId1;
    private Integer node2;
    private String bus2;
    private String connectableBus2;
    private String voltageLevelId2;

    AbstractBranchAdder() {
    }

    public T setNode1(int node1) {
        this.node1 = node1;
        return (T)this;
    }

    public T setBus1(String bus1) {
        this.bus1 = bus1;
        return (T)this;
    }

    public T setConnectableBus1(String connectableBus1) {
        this.connectableBus1 = connectableBus1;
        return (T)this;
    }

    public T setVoltageLevel1(String voltageLevelId1) {
        this.voltageLevelId1 = voltageLevelId1;
        return (T)this;
    }

    protected TerminalExt checkAndGetTerminal1() {
        VoltageLevelExt voltageLevel = this.checkAndGetVoltageLevel1();
        return new TerminalBuilder(voltageLevel.getNetworkRef(), this, ThreeSides.ONE, null).setNode(this.node1).setBus(this.bus1).setConnectableBus(this.connectableBus1).build();
    }

    protected VoltageLevelExt checkAndGetVoltageLevel1() {
        VoltageLevelExt voltageLevel1;
        if (this.voltageLevelId1 == null) {
            String defaultVoltageLevelId1 = this.checkAndGetDefaultVoltageLevelId(this.connectableBus1);
            if (defaultVoltageLevelId1 == null) {
                throw new ValidationException((Validable)this, "first voltage level is not set and has no default value");
            }
            this.voltageLevelId1 = defaultVoltageLevelId1;
        }
        if ((voltageLevel1 = this.getNetwork().getVoltageLevel(this.voltageLevelId1)) == null) {
            throw new ValidationException((Validable)this, AbstractBranchAdder.getNotFoundMessage("first voltage level", this.voltageLevelId1));
        }
        return voltageLevel1;
    }

    public T setNode2(int node2) {
        this.node2 = node2;
        return (T)this;
    }

    public T setBus2(String bus2) {
        this.bus2 = bus2;
        return (T)this;
    }

    public T setConnectableBus2(String connectableBus2) {
        this.connectableBus2 = connectableBus2;
        return (T)this;
    }

    public T setVoltageLevel2(String voltageLevelId2) {
        this.voltageLevelId2 = voltageLevelId2;
        return (T)this;
    }

    protected TerminalExt checkAndGetTerminal2() {
        VoltageLevelExt voltageLevel = this.checkAndGetVoltageLevel2();
        return new TerminalBuilder(voltageLevel.getNetworkRef(), this, ThreeSides.TWO, null).setNode(this.node2).setBus(this.bus2).setConnectableBus(this.connectableBus2).build();
    }

    protected VoltageLevelExt checkAndGetVoltageLevel2() {
        VoltageLevelExt voltageLevel2;
        if (this.voltageLevelId2 == null) {
            String defaultVoltageLevelId2 = this.checkAndGetDefaultVoltageLevelId(this.connectableBus2);
            if (defaultVoltageLevelId2 == null) {
                throw new ValidationException((Validable)this, "second voltage level is not set and has no default value");
            }
            this.voltageLevelId2 = defaultVoltageLevelId2;
        }
        if ((voltageLevel2 = this.getNetwork().getVoltageLevel(this.voltageLevelId2)) == null) {
            throw new ValidationException((Validable)this, AbstractBranchAdder.getNotFoundMessage("second voltage level", this.voltageLevelId2));
        }
        return voltageLevel2;
    }

    private String checkAndGetDefaultVoltageLevelId(String connectableBus) {
        if (connectableBus == null) {
            return null;
        }
        BusExt busExt = (BusExt)this.getNetwork().getBusBreakerView().getBus(connectableBus);
        if (busExt == null) {
            throw new ValidationException((Validable)this, AbstractBranchAdder.getNotFoundMessage("bus", connectableBus));
        }
        return busExt.getVoltageLevel().getId();
    }

    protected void checkConnectableBuses() {
        if (this.connectableBus1 == null && this.bus1 != null) {
            this.connectableBus1 = this.bus1;
        }
        if (this.connectableBus2 == null && this.bus2 != null) {
            this.connectableBus2 = this.bus2;
        }
    }

    private static String getNotFoundMessage(String type, String id) {
        return type + " '" + id + "' not found";
    }
}

