/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyPoint;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.ConnectDisconnectUtil;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkExt;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.Referrer;
import com.powsybl.iidm.network.impl.TerminalBuilder;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.TopologyModel;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.util.SwitchPredicates;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

abstract class AbstractConnectable<I extends Connectable<I>>
extends AbstractIdentifiable<I>
implements Connectable<I>,
MultiVariantObject {
    protected final List<TerminalExt> terminals = new ArrayList<TerminalExt>();
    private final Ref<NetworkImpl> networkRef;
    protected boolean removed = false;

    AbstractConnectable(Ref<NetworkImpl> ref, String id, String name, boolean fictitious) {
        super(id, name, fictitious);
        this.networkRef = Objects.requireNonNull(ref);
    }

    void addTerminal(TerminalExt terminal) {
        this.terminals.add(terminal);
        terminal.setConnectable(this);
    }

    public List<TerminalExt> getTerminals() {
        return this.terminals;
    }

    public NetworkExt getParentNetwork() {
        List<NetworkExt> subnetworks = this.terminals.stream().map(t -> t.getVoltageLevel().getParentNetwork()).distinct().toList();
        if (subnetworks.size() == 1) {
            return subnetworks.get(0);
        }
        return this.getNetwork();
    }

    @Override
    public NetworkImpl getNetwork() {
        if (this.removed) {
            throw new PowsyblException("Cannot access network of removed equipment " + this.id);
        }
        return (NetworkImpl)this.networkRef.get();
    }

    public void remove() {
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        network.getIndex().remove(this);
        for (TerminalExt terminal : this.terminals) {
            terminal.getReferrerManager().notifyOfRemoval();
            VoltageLevelExt vl = terminal.getVoltageLevel();
            vl.getTopologyModel().detach(terminal);
        }
        network.getListeners().notifyAfterRemoval(this.id);
        this.removed = true;
        this.terminals.forEach(TerminalExt::remove);
    }

    protected void notifyUpdate(Supplier<String> attribute, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(this, attribute, oldValue, newValue);
    }

    protected void notifyUpdate(String attribute, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(this, attribute, oldValue, newValue);
    }

    protected void notifyUpdate(Supplier<String> attribute, String variantId, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(this, attribute, variantId, oldValue, newValue);
    }

    protected void notifyUpdate(String attribute, String variantId, Object oldValue, Object newValue) {
        this.getNetwork().getListeners().notifyUpdate(this, attribute, variantId, oldValue, newValue);
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        for (TerminalExt t : this.terminals) {
            t.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        for (TerminalExt t : this.terminals) {
            t.reduceVariantArraySize(number);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        for (TerminalExt t : this.terminals) {
            t.deleteVariantArrayElement(index);
        }
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (TerminalExt t : this.terminals) {
            t.allocateVariantArrayElement(indexes, sourceIndex);
        }
    }

    protected void move(TerminalExt oldTerminal, int node, String voltageLevelId) {
        VoltageLevelExt voltageLevel = this.getNetwork().getVoltageLevel(voltageLevelId);
        if (voltageLevel == null) {
            throw new PowsyblException("Voltage level '" + voltageLevelId + "' not found");
        }
        if (voltageLevel.getTopologyKind() != TopologyKind.NODE_BREAKER) {
            String msg = String.format("Trying to move connectable %s to node %d of voltage level %s, which is a bus breaker voltage level", this.getId(), node, voltageLevel.getId());
            throw new PowsyblException(msg);
        }
        TerminalExt terminalExt = new TerminalBuilder(voltageLevel.getNetworkRef(), this, oldTerminal.getSide(), oldTerminal.getTerminalNumber()).setNode(node).build();
        this.replaceTerminal(oldTerminal, voltageLevel.getTopologyModel(), terminalExt, true);
    }

    protected void move(TerminalExt oldTerminal, String busId, boolean connected) {
        Bus bus = this.getNetwork().getBusBreakerView().getBus(busId);
        if (bus == null) {
            throw new PowsyblException("Bus '" + busId + "' not found");
        }
        if (bus.getVoltageLevel().getTopologyKind() != TopologyKind.BUS_BREAKER) {
            throw new PowsyblException(String.format("Trying to move connectable %s to bus %s of voltage level %s, which is a node breaker voltage level", this.getId(), bus.getId(), bus.getVoltageLevel().getId()));
        }
        TerminalExt terminalExt = new TerminalBuilder(((VoltageLevelExt)bus.getVoltageLevel()).getNetworkRef(), this, oldTerminal.getSide(), oldTerminal.getTerminalNumber()).setBus(connected ? bus.getId() : null).setConnectableBus(bus.getId()).build();
        this.replaceTerminal(oldTerminal, ((VoltageLevelExt)bus.getVoltageLevel()).getTopologyModel(), terminalExt, true);
    }

    void replaceTerminal(TerminalExt oldTerminal, TopologyPoint oldTopologyPoint, TerminalExt newTerminalExt, boolean notify) {
        Objects.requireNonNull(oldTerminal);
        Objects.requireNonNull(newTerminalExt);
        int iSide = this.terminals.indexOf(oldTerminal);
        if (iSide == -1) {
            throw new PowsyblException("Terminal to replace not found");
        }
        this.terminals.set(iSide, newTerminalExt);
        if (notify) {
            this.notifyUpdate("terminal" + (iSide + 1), (Object)oldTopologyPoint, (Object)newTerminalExt.getTopologyPoint());
        }
    }

    void replaceTerminal(TerminalExt oldTerminal, TopologyModel newTopologyModel, TerminalExt newTerminalExt, boolean notify) {
        Objects.requireNonNull(oldTerminal);
        Objects.requireNonNull(newTopologyModel);
        Objects.requireNonNull(newTerminalExt);
        newTerminalExt.setConnectable(this);
        newTopologyModel.attach(newTerminalExt, false);
        TopologyPoint oldTopologyPoint = oldTerminal.getTopologyPoint();
        oldTerminal.getVoltageLevel().getTopologyModel().detach(oldTerminal);
        this.replaceTerminal(oldTerminal, oldTopologyPoint, newTerminalExt, notify);
        for (Referrer<Terminal> referrer : oldTerminal.getReferrerManager().getReferrers()) {
            referrer.onReferencedReplacement(oldTerminal, newTerminalExt);
        }
    }

    public boolean connect() {
        return this.connect(SwitchPredicates.IS_NONFICTIONAL_BREAKER);
    }

    public boolean connect(Predicate<Switch> isTypeSwitchToOperate) {
        return this.connect(isTypeSwitchToOperate, null);
    }

    public boolean connect(Predicate<Switch> isTypeSwitchToOperate, ThreeSides side) {
        return ConnectDisconnectUtil.connectAllTerminals(this, this.getTerminals(side), isTypeSwitchToOperate, this.getNetwork().getReportNodeContext().getReportNode());
    }

    public boolean disconnect() {
        return this.disconnect(SwitchPredicates.IS_CLOSED_BREAKER);
    }

    public boolean disconnect(Predicate<Switch> isSwitchOpenable) {
        return this.disconnect(isSwitchOpenable, null);
    }

    public boolean disconnect(Predicate<Switch> isSwitchOpenable, ThreeSides side) {
        return ConnectDisconnectUtil.disconnectAllTerminals(this, this.getTerminals(side), isSwitchOpenable, this.getNetwork().getReportNodeContext().getReportNode());
    }

    public List<TerminalExt> getTerminals(ThreeSides side) {
        if (side == null) {
            return this.terminals;
        }
        return this.terminals.stream().filter(terminal -> terminal.getSide().equals((Object)side)).toList();
    }
}

