/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.DcConnectable;
import com.powsybl.iidm.network.DcTerminal;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.DcTerminalImpl;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

abstract class AbstractDcConnectable<I extends DcConnectable<I>>
extends AbstractIdentifiable<I>
implements DcConnectable<I>,
MultiVariantObject {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    protected final List<DcTerminalImpl> dcTerminals = new ArrayList<DcTerminalImpl>();
    protected boolean removed = false;

    AbstractDcConnectable(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef, String id, String name, boolean fictitious) {
        super(id, name, fictitious);
        this.networkRef = Objects.requireNonNull(ref);
        this.subnetworkRef = subnetworkRef;
    }

    public Network getParentNetwork() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"network");
        return Optional.ofNullable((Network)this.subnetworkRef.get()).orElse(this.getNetwork());
    }

    @Override
    public NetworkImpl getNetwork() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"network");
        return (NetworkImpl)this.networkRef.get();
    }

    public List<DcTerminal> getDcTerminals() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"dcTerminals");
        return List.copyOf(this.dcTerminals);
    }

    void addDcTerminal(DcTerminalImpl dcTerminal) {
        this.dcTerminals.add(dcTerminal);
        dcTerminal.setDcConnectable(this);
    }

    public void remove() {
        NetworkImpl network = this.getNetwork();
        network.getListeners().notifyBeforeRemoval(this);
        network.getIndex().remove(this);
        this.dcTerminals.forEach(dcTerminal -> {
            ((AbstractNetwork)this.getParentNetwork()).getDcTopologyModel().detach((DcTerminalImpl)dcTerminal);
            dcTerminal.remove();
        });
        network.getListeners().notifyAfterRemoval(this.id);
        this.removed = true;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        super.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        for (DcTerminalImpl t : this.dcTerminals) {
            t.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        super.reduceVariantArraySize(number);
        for (DcTerminalImpl t : this.dcTerminals) {
            t.reduceVariantArraySize(number);
        }
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        super.deleteVariantArrayElement(index);
        for (DcTerminalImpl t : this.dcTerminals) {
            t.deleteVariantArrayElement(index);
        }
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        super.allocateVariantArrayElement(indexes, sourceIndex);
        for (DcTerminalImpl t : this.dcTerminals) {
            t.allocateVariantArrayElement(indexes, sourceIndex);
        }
    }
}

