/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.google.common.collect.FluentIterable;
import com.powsybl.iidm.network.DcConnectable;
import com.powsybl.iidm.network.DcGround;
import com.powsybl.iidm.network.DcLine;
import com.powsybl.iidm.network.DcTerminal;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LineCommutatedConverter;
import com.powsybl.iidm.network.VoltageSourceConverter;
import com.powsybl.iidm.network.impl.AbstractIdentifiable;
import java.util.List;
import java.util.stream.Stream;

public abstract class AbstractDcTopologyVisitable<I extends Identifiable<I>>
extends AbstractIdentifiable<I> {
    AbstractDcTopologyVisitable(String id, String name) {
        super(id, name);
    }

    AbstractDcTopologyVisitable(String id, String name, boolean fictitious) {
        super(id, name, fictitious);
    }

    abstract List<DcTerminal> getConnectedDcTerminals();

    abstract Stream<DcTerminal> getConnectedDcTerminalStream();

    public Iterable<DcGround> getDcGrounds() {
        return this.getDcConnectables(DcGround.class);
    }

    public Stream<DcGround> getDcGroundStream() {
        return this.getDcConnectableStream(DcGround.class);
    }

    public Iterable<DcLine> getDcLines() {
        return this.getDcConnectables(DcLine.class);
    }

    public Stream<DcLine> getDcLineStream() {
        return this.getDcConnectableStream(DcLine.class);
    }

    public Iterable<LineCommutatedConverter> getLineCommutatedConverters() {
        return this.getDcConnectables(LineCommutatedConverter.class);
    }

    public Stream<LineCommutatedConverter> getLineCommutatedConverterStream() {
        return this.getDcConnectableStream(LineCommutatedConverter.class);
    }

    public Iterable<VoltageSourceConverter> getVoltageSourceConverters() {
        return this.getDcConnectables(VoltageSourceConverter.class);
    }

    public Stream<VoltageSourceConverter> getVoltageSourceConverterStream() {
        return this.getDcConnectableStream(VoltageSourceConverter.class);
    }

    private <C extends DcConnectable<C>> Iterable<C> getDcConnectables(Class<C> clazz) {
        return FluentIterable.from(this.getConnectedDcTerminals()).transform(DcTerminal::getDcConnectable).filter(clazz);
    }

    protected <C extends DcConnectable<C>> Stream<C> getDcConnectableStream(Class<C> clazz) {
        return this.getConnectedDcTerminalStream().map(DcTerminal::getDcConnectable).filter(clazz::isInstance).map(clazz::cast);
    }
}

