/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.OperationalLimitsGroupImpl;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractLoadingLimits<L extends AbstractLoadingLimits<L>>
implements LoadingLimits {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLoadingLimits.class);
    protected final OperationalLimitsGroupImpl group;
    private double permanentLimit;
    private final TreeMap<Integer, LoadingLimits.TemporaryLimit> temporaryLimits;

    AbstractLoadingLimits(OperationalLimitsGroupImpl owner, double permanentLimit, TreeMap<Integer, LoadingLimits.TemporaryLimit> temporaryLimits) {
        this.group = Objects.requireNonNull(owner);
        this.permanentLimit = permanentLimit;
        this.temporaryLimits = Objects.requireNonNull(temporaryLimits);
    }

    public double getPermanentLimit() {
        return this.permanentLimit;
    }

    public L setPermanentLimit(double permanentLimit) {
        NetworkImpl network = this.group.getNetwork();
        ValidationUtil.checkPermanentLimit((Validable)this.group.getValidable(), (double)permanentLimit, this.getTemporaryLimits(), (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode());
        double oldValue = this.permanentLimit;
        this.permanentLimit = permanentLimit;
        network.invalidateValidationLevel();
        this.group.notifyPermanentLimitUpdate(this.getLimitType(), oldValue, this.permanentLimit);
        return (L)this;
    }

    public L setTemporaryLimitValue(int acceptableDuration, double temporaryLimitValue) {
        if (temporaryLimitValue < 0.0 || Double.isNaN(temporaryLimitValue)) {
            throw new ValidationException(this.group.getValidable(), "Temporary limit value must be a positive double");
        }
        LoadingLimits.TemporaryLimit identifiedLimit = this.getTemporaryLimit(acceptableDuration);
        if (identifiedLimit == null) {
            throw new ValidationException(this.group.getValidable(), "No temporary limit found for the given acceptable duration");
        }
        TreeMap<Integer, LoadingLimits.TemporaryLimit> temporaryLimitTreeMap = new TreeMap<Integer, LoadingLimits.TemporaryLimit>((SortedMap<Integer, LoadingLimits.TemporaryLimit>)this.temporaryLimits);
        Map.Entry<Integer, LoadingLimits.TemporaryLimit> biggerDurationEntry = temporaryLimitTreeMap.lowerEntry(acceptableDuration);
        Map.Entry<Integer, LoadingLimits.TemporaryLimit> smallerDurationEntry = temporaryLimitTreeMap.higherEntry(acceptableDuration);
        double oldValue = identifiedLimit.getValue();
        if (this.isTemporaryLimitValueValid(biggerDurationEntry, smallerDurationEntry, acceptableDuration, temporaryLimitValue)) {
            LOGGER.info("{}Temporary limit value changed from {} to {}", new Object[]{this.group.getValidable().getMessageHeader(), oldValue, temporaryLimitValue});
        } else {
            LOGGER.warn("{}Temporary limit value changed from {} to {}, but it is not valid", new Object[]{this.group.getValidable().getMessageHeader(), oldValue, temporaryLimitValue});
        }
        this.temporaryLimits.put(acceptableDuration, new TemporaryLimitImpl(identifiedLimit.getName(), temporaryLimitValue, identifiedLimit.getAcceptableDuration(), identifiedLimit.isFictitious()));
        this.group.notifyTemporaryLimitValueUpdate(this.getLimitType(), oldValue, temporaryLimitValue, acceptableDuration);
        return (L)this;
    }

    protected boolean isTemporaryLimitValueValid(Map.Entry<Integer, LoadingLimits.TemporaryLimit> biggerDurationEntry, Map.Entry<Integer, LoadingLimits.TemporaryLimit> smallerDurationEntry, int acceptableDuration, double temporaryLimitValue) {
        boolean checkAgainstBigger = true;
        boolean checkAgainstSmaller = true;
        if (biggerDurationEntry != null) {
            boolean bl = checkAgainstBigger = biggerDurationEntry.getValue().getAcceptableDuration() > acceptableDuration && biggerDurationEntry.getValue().getValue() < temporaryLimitValue;
        }
        if (smallerDurationEntry != null) {
            checkAgainstSmaller = smallerDurationEntry.getValue().getAcceptableDuration() < acceptableDuration && smallerDurationEntry.getValue().getValue() > temporaryLimitValue;
        }
        return temporaryLimitValue > this.permanentLimit && checkAgainstBigger && checkAgainstSmaller;
    }

    public Collection<LoadingLimits.TemporaryLimit> getTemporaryLimits() {
        return this.temporaryLimits.values();
    }

    public LoadingLimits.TemporaryLimit getTemporaryLimit(int acceptableDuration) {
        return this.temporaryLimits.get(acceptableDuration);
    }

    public double getTemporaryLimitValue(int acceptableDuration) {
        LoadingLimits.TemporaryLimit tl = this.getTemporaryLimit(acceptableDuration);
        return tl != null ? tl.getValue() : Double.NaN;
    }

    static class TemporaryLimitImpl
    implements LoadingLimits.TemporaryLimit {
        private final String name;
        private double value;
        private final int acceptableDuration;
        private final boolean fictitious;

        TemporaryLimitImpl(String name, double value, int acceptableDuration, boolean hasOverloadingProtection) {
            this.name = Objects.requireNonNull(name);
            this.value = value;
            this.acceptableDuration = acceptableDuration;
            this.fictitious = hasOverloadingProtection;
        }

        public String getName() {
            return this.name;
        }

        public double getValue() {
            return this.value;
        }

        public int getAcceptableDuration() {
            return this.acceptableDuration;
        }

        public boolean isFictitious() {
            return this.fictitious;
        }
    }
}

