/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.MultiVariantObject;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.RegulatingPoint;
import com.powsybl.iidm.network.impl.TapChangerParent;
import com.powsybl.iidm.network.impl.TapChangerStepImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

abstract class AbstractTapChanger<H extends TapChangerParent, C extends AbstractTapChanger<H, C, S>, S extends TapChangerStepImpl<S>>
implements MultiVariantObject {
    protected final Ref<? extends VariantManagerHolder> network;
    protected final H parent;
    protected boolean loadTapChangingCapabilities;
    protected int lowTapPosition;
    protected Integer relativeNeutralPosition;
    protected List<S> steps;
    private final String type;
    protected final RegulatingPoint regulatingPoint;
    protected final ArrayList<Integer> tapPosition;
    protected final TDoubleArrayList targetDeadband;
    protected final ArrayList<Integer> solvedTapPosition;

    protected AbstractTapChanger(H parent, int lowTapPosition, List<S> steps, TerminalExt regulationTerminal, boolean loadTapChangingCapabilities, Integer tapPosition, Integer solvedTapPosition, boolean regulating, double targetDeadband, String type) {
        this.network = parent.getParentNetwork().getRootNetworkRef();
        this.parent = parent;
        this.loadTapChangingCapabilities = loadTapChangingCapabilities;
        this.lowTapPosition = lowTapPosition;
        this.steps = steps;
        steps.forEach(s -> s.setParent(this));
        int variantArraySize = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantArraySize();
        this.regulatingPoint = this.createRegulatingPoint(variantArraySize, regulating);
        this.regulatingPoint.setRegulatingTerminal(regulationTerminal);
        this.tapPosition = new ArrayList(variantArraySize);
        this.solvedTapPosition = new ArrayList(variantArraySize);
        this.targetDeadband = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.tapPosition.add(tapPosition);
            this.solvedTapPosition.add(solvedTapPosition);
            this.targetDeadband.add(targetDeadband);
        }
        this.type = Objects.requireNonNull(type);
        this.relativeNeutralPosition = this.getRelativeNeutralPosition();
    }

    protected abstract RegulatingPoint createRegulatingPoint(int var1, boolean var2);

    protected NetworkImpl getNetwork() {
        return this.parent.getNetwork();
    }

    protected abstract Integer getRelativeNeutralPosition();

    public int getStepCount() {
        return this.steps.size();
    }

    public int getLowTapPosition() {
        return this.lowTapPosition;
    }

    public C setLowTapPosition(int lowTapPosition) {
        int oldValue = this.lowTapPosition;
        this.lowTapPosition = lowTapPosition;
        this.parent.getNetwork().getListeners().notifyUpdate(this.parent.getTransformer(), () -> this.getTapChangerAttribute() + ".lowTapPosition", (Object)oldValue, (Object)lowTapPosition);
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        Integer position = this.tapPosition.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
        this.tapPosition.set(variantIndex, position != null ? Integer.valueOf(position + (this.lowTapPosition - oldValue)) : null);
        return (C)this;
    }

    public int getHighTapPosition() {
        return this.lowTapPosition + this.steps.size() - 1;
    }

    public int getTapPosition() {
        Integer position = this.tapPosition.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
        if (position == null) {
            throw ValidationUtil.createUndefinedValueGetterException();
        }
        return position;
    }

    public OptionalInt findTapPosition() {
        Integer position = this.tapPosition.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
        return position == null ? OptionalInt.empty() : OptionalInt.of(position);
    }

    public Integer getSolvedTapPosition() {
        return this.solvedTapPosition.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public OptionalInt findSolvedTapPosition() {
        Integer solvedPosition = this.solvedTapPosition.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
        return solvedPosition == null ? OptionalInt.empty() : OptionalInt.of(solvedPosition);
    }

    public OptionalInt getNeutralPosition() {
        return this.relativeNeutralPosition != null ? OptionalInt.of(this.lowTapPosition + this.relativeNeutralPosition) : OptionalInt.empty();
    }

    protected abstract String getTapChangerAttribute();

    public C setTapPosition(int tapPosition) {
        NetworkImpl n = this.getNetwork();
        if (tapPosition < this.lowTapPosition || tapPosition > this.getHighTapPosition()) {
            this.throwIncorrectTapPosition(tapPosition, this.getHighTapPosition());
        }
        int variantIndex = n.getVariantIndex();
        Integer oldValue = this.tapPosition.set(variantIndex, tapPosition);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        this.parent.getNetwork().getListeners().notifyUpdate(this.parent.getTransformer(), () -> this.getTapChangerAttribute() + ".tapPosition", variantId, (Object)oldValue, (Object)tapPosition);
        return (C)this;
    }

    public C unsetTapPosition() {
        NetworkImpl n = this.getNetwork();
        ValidationUtil.throwExceptionOrIgnore(this.parent, (String)"tap position has been unset", (ValidationLevel)n.getMinValidationLevel());
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        Integer oldValue = this.tapPosition.set(variantIndex, null);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        n.getListeners().notifyUpdate(this.parent.getTransformer(), () -> this.getTapChangerAttribute() + ".tapPosition", variantId, (Object)oldValue, null);
        return (C)this;
    }

    public C setSolvedTapPosition(int solvedTapPosition) {
        NetworkImpl n = this.getNetwork();
        if (solvedTapPosition < this.lowTapPosition || solvedTapPosition > this.getHighTapPosition()) {
            this.throwIncorrectSolvedTapPosition(solvedTapPosition, this.getHighTapPosition());
        }
        int variantIndex = n.getVariantIndex();
        Integer oldValue = this.solvedTapPosition.set(variantIndex, solvedTapPosition);
        String variantId = n.getVariantManager().getVariantId(variantIndex);
        this.parent.getNetwork().getListeners().notifyUpdate(this.parent.getTransformer(), () -> this.getTapChangerAttribute() + ".solvedTapPosition", variantId, (Object)oldValue, (Object)solvedTapPosition);
        return (C)this;
    }

    public C unsetSolvedTapPosition() {
        NetworkImpl n = this.getNetwork();
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        Integer oldValue = this.solvedTapPosition.set(variantIndex, null);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.getListeners().notifyUpdate(this.parent.getTransformer(), () -> this.getTapChangerAttribute() + ".solvedTapPosition", variantId, (Object)oldValue, null);
        return (C)this;
    }

    public S getStep(int tapPosition) {
        if (tapPosition < this.lowTapPosition || tapPosition > this.getHighTapPosition()) {
            this.throwIncorrectTapPosition(tapPosition, this.getHighTapPosition());
        }
        return (S)((TapChangerStepImpl)this.steps.get(tapPosition - this.lowTapPosition));
    }

    protected C setSteps(List<S> steps) {
        OptionalInt solvedTap;
        if (steps == null || steps.isEmpty()) {
            throw new ValidationException(this.parent, "a tap changer shall have at least one step");
        }
        steps.forEach(step -> step.validate((TapChangerParent)this.parent));
        int newHighTapPosition = this.lowTapPosition + steps.size() - 1;
        if (this.getTapPosition() > newHighTapPosition) {
            this.throwIncorrectTapPosition(this.getTapPosition(), newHighTapPosition);
        }
        if ((solvedTap = this.findSolvedTapPosition()).isPresent() && solvedTap.getAsInt() > newHighTapPosition) {
            this.throwIncorrectSolvedTapPosition(solvedTap.getAsInt(), newHighTapPosition);
        }
        this.steps = steps;
        this.relativeNeutralPosition = this.getRelativeNeutralPosition();
        return (C)this;
    }

    public S getCurrentStep() {
        Integer position = this.tapPosition.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
        if (position == null) {
            return null;
        }
        return this.getStep(position);
    }

    public S getSolvedCurrentStep() {
        Integer solvedPosition = this.solvedTapPosition.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
        if (solvedPosition == null) {
            return null;
        }
        return this.getStep(solvedPosition);
    }

    public boolean isRegulating() {
        return this.regulatingPoint.isRegulating(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public C setRegulating(boolean regulating) {
        NetworkImpl n = this.getNetwork();
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        ValidationUtil.checkTargetDeadband(this.parent, (String)this.type, (boolean)regulating, (double)this.targetDeadband.get(variantIndex), (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        boolean oldValue = this.regulatingPoint.setRegulating(variantIndex, regulating);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        n.getListeners().notifyUpdate(this.parent.getTransformer(), () -> this.getTapChangerAttribute() + ".regulating", variantId, (Object)oldValue, (Object)regulating);
        return (C)this;
    }

    public TerminalExt getRegulationTerminal() {
        return this.regulatingPoint.getRegulatingTerminal();
    }

    public C setRegulationTerminal(Terminal regulationTerminal) {
        if (regulationTerminal != null && ((TerminalExt)regulationTerminal).getVoltageLevel().getNetwork() != this.getNetwork()) {
            throw new ValidationException(this.parent, "regulation terminal is not part of the network");
        }
        TerminalExt oldValue = this.regulatingPoint.getRegulatingTerminal();
        this.regulatingPoint.setRegulatingTerminal((TerminalExt)regulationTerminal);
        this.getNetwork().getListeners().notifyUpdate(this.parent.getTransformer(), () -> this.getTapChangerAttribute() + ".regulationTerminal", (Object)oldValue, (Object)regulationTerminal);
        return (C)this;
    }

    public double getTargetDeadband() {
        return this.targetDeadband.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public C setTargetDeadband(double targetDeadband) {
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        NetworkImpl n = this.getNetwork();
        ValidationUtil.checkTargetDeadband(this.parent, (String)this.type, (boolean)this.regulatingPoint.isRegulating(variantIndex), (double)targetDeadband, (ValidationLevel)n.getMinValidationLevel(), (ReportNode)n.getReportNodeContext().getReportNode());
        double oldValue = this.targetDeadband.set(variantIndex, targetDeadband);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        n.invalidateValidationLevel();
        n.getListeners().notifyUpdate(this.parent.getTransformer(), () -> this.getTapChangerAttribute() + ".targetDeadband", variantId, (Object)oldValue, (Object)targetDeadband);
        return (C)this;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.targetDeadband.ensureCapacity(this.targetDeadband.size() + number);
        this.tapPosition.ensureCapacity(this.tapPosition.size() + number);
        this.solvedTapPosition.ensureCapacity(this.solvedTapPosition.size() + number);
        for (int i = 0; i < number; ++i) {
            this.tapPosition.add(this.tapPosition.get(sourceIndex));
            this.targetDeadband.add(this.targetDeadband.get(sourceIndex));
            this.solvedTapPosition.add(this.solvedTapPosition.get(sourceIndex));
        }
        this.regulatingPoint.extendVariantArraySize(initVariantArraySize, number, sourceIndex);
    }

    @Override
    public void reduceVariantArraySize(int number) {
        ArrayList<Integer> tmpInt = new ArrayList<Integer>(this.tapPosition.subList(0, this.tapPosition.size() - number));
        this.tapPosition.clear();
        this.tapPosition.addAll(tmpInt);
        ArrayList<Integer> tmpSolvedTapPosition = new ArrayList<Integer>(this.solvedTapPosition.subList(0, this.solvedTapPosition.size() - number));
        this.solvedTapPosition.clear();
        this.solvedTapPosition.addAll(tmpSolvedTapPosition);
        this.targetDeadband.remove(this.targetDeadband.size() - number, number);
        this.regulatingPoint.reduceVariantArraySize(number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
        this.regulatingPoint.deleteVariantArrayElement(index);
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.tapPosition.set(index, this.tapPosition.get(sourceIndex));
            this.solvedTapPosition.set(index, this.solvedTapPosition.get(sourceIndex));
            this.targetDeadband.set(index, this.targetDeadband.get(sourceIndex));
        }
        this.regulatingPoint.allocateVariantArrayElement(indexes, sourceIndex);
    }

    private void throwIncorrectTapPosition(int tapPosition, int highTapPosition) {
        throw new ValidationException(this.parent, "incorrect tap position " + tapPosition + " [" + this.lowTapPosition + ", " + highTapPosition + "]");
    }

    private void throwIncorrectSolvedTapPosition(int solvedTapPosition, int highTapPosition) {
        throw new ValidationException(this.parent, "incorrect solved tap position " + solvedTapPosition + " [" + this.lowTapPosition + ", " + highTapPosition + "]");
    }

    public void remove() {
        this.regulatingPoint.remove();
    }
}

