/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.TapChangerParent;
import com.powsybl.iidm.network.impl.TapChangerStepImpl;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.util.NetworkReports;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractTapChangerAdderImpl<A extends AbstractTapChangerAdderImpl<A, H, T, S>, H extends TapChangerParent, T extends TapChanger<T, ?, ?, ?>, S extends TapChangerStepImpl<S>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTapChangerAdderImpl.class);
    protected final H parent;
    private int lowTapPosition = 0;
    private Integer tapPosition;
    protected final List<S> steps;
    private double regulationValue = Double.NaN;
    private boolean regulating = false;
    private double targetDeadband = Double.NaN;
    private TerminalExt regulationTerminal;
    private boolean loadTapChangingCapabilities;
    private Integer solvedTapPosition;

    protected AbstractTapChangerAdderImpl(H parent, boolean loadTapChangingCapabilities) {
        this.parent = parent;
        this.steps = new ArrayList<S>();
        this.loadTapChangingCapabilities = loadTapChangingCapabilities;
    }

    public A setLowTapPosition(int lowTapPosition) {
        this.lowTapPosition = lowTapPosition;
        return this.self();
    }

    public A setTapPosition(int tapPosition) {
        this.tapPosition = tapPosition;
        return this.self();
    }

    public A setSolvedTapPosition(Integer solvedTapPosition) {
        this.solvedTapPosition = solvedTapPosition;
        return this.self();
    }

    public A setRegulationValue(double regulationValue) {
        this.regulationValue = regulationValue;
        return this.self();
    }

    public A setRegulating(boolean regulating) {
        this.regulating = regulating;
        return this.self();
    }

    public A setTargetDeadband(double targetDeadband) {
        this.targetDeadband = targetDeadband;
        return this.self();
    }

    public A setRegulationTerminal(Terminal regulationTerminal) {
        this.regulationTerminal = (TerminalExt)regulationTerminal;
        return this.self();
    }

    public A setLoadTapChangingCapabilities(boolean loadTapChangingCapabilities) {
        this.loadTapChangingCapabilities = loadTapChangingCapabilities;
        return this.self();
    }

    NetworkImpl getNetwork() {
        return this.parent.getNetwork();
    }

    public T add() {
        NetworkImpl network = this.getNetwork();
        if (this.tapPosition == null) {
            ValidationUtil.throwExceptionOrIgnore(this.parent, (String)"tap position is not set", (ValidationLevel)network.getMinValidationLevel());
            network.setValidationLevelIfGreaterThan(ValidationLevel.EQUIPMENT);
        }
        if (this.steps.isEmpty()) {
            throw new ValidationException(this.parent, this.getValidableType() + " should have at least one step");
        }
        int highTapPosition = this.lowTapPosition + this.steps.size() - 1;
        if (this.tapPosition != null && (this.tapPosition < this.lowTapPosition || this.tapPosition > highTapPosition)) {
            ValidationUtil.throwExceptionOrIgnore(this.parent, (String)("incorrect tap position " + this.tapPosition + " [" + this.lowTapPosition + ", " + highTapPosition + "]"), (ValidationLevel)network.getMinValidationLevel());
            network.setValidationLevelIfGreaterThan(ValidationLevel.EQUIPMENT);
        }
        if (this.solvedTapPosition != null && (this.solvedTapPosition < this.lowTapPosition || this.solvedTapPosition > highTapPosition)) {
            throw new ValidationException(this.parent, "incorrect solved tap position " + this.solvedTapPosition + " [" + this.lowTapPosition + ", " + highTapPosition + "]");
        }
        network.setValidationLevelIfGreaterThan(this.checkTapChangerRegulation(this.parent, this.regulationValue, this.regulating, this.loadTapChangingCapabilities, this.regulationTerminal));
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkTargetDeadband(this.parent, (String)this.getValidableType(), (boolean)this.regulating, (double)this.targetDeadband, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        T tapChanger = this.createTapChanger(this.parent, this.lowTapPosition, this.steps, this.regulationTerminal, this.tapPosition, this.solvedTapPosition, this.regulating, this.loadTapChangingCapabilities, this.regulationValue, this.targetDeadband);
        HashSet otherTapChangers = new HashSet(this.parent.getAllTapChangers());
        otherTapChangers.remove(tapChanger);
        network.setValidationLevelIfGreaterThan(ValidationUtil.checkOnlyOneTapChangerRegulatingEnabled(this.parent, otherTapChangers, (boolean)this.regulating, (ValidationLevel)network.getMinValidationLevel(), (ReportNode)network.getReportNodeContext().getReportNode()));
        if (this.parent.hasPhaseTapChanger() && this.parent.hasRatioTapChanger()) {
            LOGGER.warn("{} has both Ratio and Phase Tap Changer", this.parent);
            NetworkReports.transformerHasBothRatioAndPhaseTapChanger((ReportNode)network.getReportNodeContext().getReportNode(), (String)this.parent.getTransformer().getId());
        }
        return tapChanger;
    }

    protected abstract T createTapChanger(H var1, int var2, List<S> var3, TerminalExt var4, Integer var5, Integer var6, boolean var7, boolean var8, double var9, double var11);

    protected abstract A self();

    protected abstract ValidationLevel checkTapChangerRegulation(H var1, double var2, boolean var4, boolean var5, TerminalExt var6);

    protected abstract String getValidableType();
}

