/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TerminalNumber;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractConnectable;
import com.powsybl.iidm.network.impl.ReferrerManager;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VariantManagerHolder;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.util.SwitchPredicates;
import gnu.trove.list.array.TDoubleArrayList;
import java.util.List;
import java.util.function.Predicate;

abstract class AbstractTerminal
implements TerminalExt {
    protected static final String UNMODIFIABLE_REMOVED_EQUIPMENT = "Cannot modify removed equipment ";
    protected static final String CANNOT_ACCESS_BUS_REMOVED_EQUIPMENT = "Cannot access bus of removed equipment ";
    private Ref<? extends VariantManagerHolder> network;
    protected final ThreeSides side;
    protected final TerminalNumber terminalNumber;
    protected AbstractConnectable connectable;
    protected VoltageLevelExt voltageLevel;
    protected final ReferrerManager<Terminal> referrerManager = new ReferrerManager<AbstractTerminal>(this);
    protected final TDoubleArrayList p;
    protected final TDoubleArrayList q;
    protected boolean removed = false;

    AbstractTerminal(Ref<? extends VariantManagerHolder> network, ThreeSides side, TerminalNumber terminalNumber) {
        if (side != null && terminalNumber != null) {
            throw new IllegalStateException("cannot have both side and number");
        }
        this.side = side;
        this.terminalNumber = terminalNumber;
        this.network = network;
        int variantArraySize = ((VariantManagerHolder)network.get()).getVariantManager().getVariantArraySize();
        this.p = new TDoubleArrayList(variantArraySize);
        this.q = new TDoubleArrayList(variantArraySize);
        for (int i = 0; i < variantArraySize; ++i) {
            this.p.add(Double.NaN);
            this.q.add(Double.NaN);
        }
    }

    public ThreeSides getSide() {
        return this.side;
    }

    public TerminalNumber getTerminalNumber() {
        return this.terminalNumber;
    }

    protected String getAttributeSideOrNumberSuffix() {
        return String.valueOf(this.side != null ? Integer.valueOf(this.side.getNum()) : "") + String.valueOf(this.terminalNumber != null ? Integer.valueOf(this.terminalNumber.getNum()) : "");
    }

    protected VariantManagerHolder getVariantManagerHolder() {
        return (VariantManagerHolder)this.network.get();
    }

    @Override
    public AbstractConnectable getConnectable() {
        return this.connectable;
    }

    @Override
    public void setConnectable(AbstractConnectable connectable) {
        this.connectable = connectable;
    }

    @Override
    public VoltageLevelExt getVoltageLevel() {
        if (this.removed) {
            throw new PowsyblException("Cannot access voltage level of removed equipment " + this.connectable.id);
        }
        return this.voltageLevel;
    }

    @Override
    public void setVoltageLevel(VoltageLevelExt voltageLevel) {
        this.voltageLevel = voltageLevel;
        if (voltageLevel != null) {
            this.network = voltageLevel.getNetworkRef();
        }
    }

    public double getP() {
        if (this.removed) {
            throw new PowsyblException("Cannot access p of removed equipment " + this.connectable.id);
        }
        return this.p.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public Terminal setP(double p) {
        if (this.removed) {
            throw new PowsyblException(UNMODIFIABLE_REMOVED_EQUIPMENT + this.connectable.id);
        }
        if (this.connectable.getType() == IdentifiableType.BUSBAR_SECTION) {
            throw new ValidationException((Validable)this.connectable, "cannot set active power on a busbar section");
        }
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        double oldValue = this.p.set(variantIndex, p);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        this.getConnectable().notifyUpdate(() -> "p" + this.getAttributeSideOrNumberSuffix(), variantId, (Object)oldValue, (Object)p);
        return this;
    }

    public double getQ() {
        if (this.removed) {
            throw new PowsyblException("Cannot access q of removed equipment " + this.connectable.id);
        }
        return this.q.get(((VariantManagerHolder)this.network.get()).getVariantIndex());
    }

    public Terminal setQ(double q) {
        if (this.removed) {
            throw new PowsyblException(UNMODIFIABLE_REMOVED_EQUIPMENT + this.connectable.id);
        }
        if (this.connectable.getType() == IdentifiableType.BUSBAR_SECTION) {
            throw new ValidationException((Validable)this.connectable, "cannot set reactive power on a busbar section");
        }
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        double oldValue = this.q.set(variantIndex, q);
        String variantId = ((VariantManagerHolder)this.network.get()).getVariantManager().getVariantId(variantIndex);
        this.getConnectable().notifyUpdate(() -> "q" + this.getAttributeSideOrNumberSuffix(), variantId, (Object)oldValue, (Object)q);
        return this;
    }

    protected abstract double getV();

    public double getI() {
        if (this.removed) {
            throw new PowsyblException("Cannot access i of removed equipment " + this.connectable.id);
        }
        if (this.connectable.getType() == IdentifiableType.BUSBAR_SECTION) {
            return 0.0;
        }
        int variantIndex = ((VariantManagerHolder)this.network.get()).getVariantIndex();
        return Math.hypot(this.p.get(variantIndex), this.q.get(variantIndex)) / (Math.sqrt(3.0) * this.getV() / 1000.0);
    }

    public boolean connect() {
        return this.connect(SwitchPredicates.IS_NONFICTIONAL_BREAKER);
    }

    public boolean connect(Predicate<Switch> isTypeSwitchToOperate) {
        if (this.removed) {
            throw new PowsyblException(UNMODIFIABLE_REMOVED_EQUIPMENT + this.connectable.id);
        }
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        String variantId = this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
        boolean connectedBefore = this.isConnected();
        this.connectable.notifyUpdate("beginConnect", variantId, (Object)connectedBefore, null);
        boolean connected = this.voltageLevel.getTopologyModel().connect(this, isTypeSwitchToOperate);
        boolean connectedAfter = this.isConnected();
        this.connectable.notifyUpdate("endConnect", variantId, null, (Object)connectedAfter);
        return connected;
    }

    public boolean disconnect() {
        return this.disconnect(SwitchPredicates.IS_CLOSED_BREAKER);
    }

    public boolean disconnect(Predicate<Switch> isSwitchOpenable) {
        if (this.removed) {
            throw new PowsyblException(UNMODIFIABLE_REMOVED_EQUIPMENT + this.connectable.id);
        }
        int variantIndex = this.getVariantManagerHolder().getVariantIndex();
        String variantId = this.getVariantManagerHolder().getVariantManager().getVariantId(variantIndex);
        boolean disconnectedBefore = !this.isConnected();
        this.connectable.notifyUpdate("beginDisconnect", variantId, (Object)disconnectedBefore, null);
        boolean disconnected = this.voltageLevel.getTopologyModel().disconnect(this, isSwitchOpenable);
        boolean disconnectedAfter = !this.isConnected();
        this.connectable.notifyUpdate("endDisconnect", variantId, null, (Object)disconnectedAfter);
        return disconnected;
    }

    @Override
    public void extendVariantArraySize(int initVariantArraySize, int number, int sourceIndex) {
        this.p.ensureCapacity(this.p.size() + number);
        this.q.ensureCapacity(this.q.size() + number);
        for (int i = 0; i < number; ++i) {
            this.p.add(this.p.get(sourceIndex));
            this.q.add(this.q.get(sourceIndex));
        }
    }

    @Override
    public void reduceVariantArraySize(int number) {
        this.p.remove(this.p.size() - number, number);
        this.q.remove(this.q.size() - number, number);
    }

    @Override
    public void deleteVariantArrayElement(int index) {
    }

    @Override
    public void allocateVariantArrayElement(int[] indexes, int sourceIndex) {
        for (int index : indexes) {
            this.p.set(index, this.p.get(sourceIndex));
            this.q.set(index, this.q.get(sourceIndex));
        }
    }

    @Override
    public void remove() {
        this.removed = true;
    }

    @Override
    public ReferrerManager<Terminal> getReferrerManager() {
        return this.referrerManager;
    }

    public List<Object> getReferrers() {
        return this.referrerManager.getReferrers().stream().map(r -> r).toList();
    }
}

