/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.LimitType;
import com.powsybl.iidm.network.Overload;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.util.LimitViolationUtils;
import java.util.Objects;
import java.util.function.Supplier;

public final class BranchUtil {
    private BranchUtil() {
    }

    static Terminal getTerminal(String voltageLevelId, Terminal terminal1, Terminal terminal2) {
        Objects.requireNonNull(voltageLevelId);
        boolean side1 = terminal1.getVoltageLevel().getId().equals(voltageLevelId);
        boolean side2 = terminal2.getVoltageLevel().getId().equals(voltageLevelId);
        if (side1 && side2) {
            throw new PowsyblException("Both terminals are connected to voltage level " + voltageLevelId);
        }
        if (side1) {
            return terminal1;
        }
        if (side2) {
            return terminal2;
        }
        throw new PowsyblException("No terminal connected to voltage level " + voltageLevelId);
    }

    public static TwoSides getSide(Terminal terminal, Terminal terminal1, Terminal terminal2) {
        Objects.requireNonNull(terminal);
        if (terminal1 == terminal) {
            return TwoSides.ONE;
        }
        if (terminal2 == terminal) {
            return TwoSides.TWO;
        }
        throw new IllegalStateException("The terminal is not connected to this branch");
    }

    static <T> T getFromSide(TwoSides side, Supplier<T> getter1, Supplier<T> getter2) {
        Objects.requireNonNull(side);
        if (side == TwoSides.ONE) {
            return getter1.get();
        }
        if (side == TwoSides.TWO) {
            return getter2.get();
        }
        throw new IllegalStateException("Unexpected side: " + String.valueOf(side));
    }

    static int getOverloadDuration(Overload o1, Overload o2) {
        int duration1 = o1 != null ? o1.getTemporaryLimit().getAcceptableDuration() : Integer.MAX_VALUE;
        int duration2 = o2 != null ? o2.getTemporaryLimit().getAcceptableDuration() : Integer.MAX_VALUE;
        return Math.min(duration1, duration2);
    }

    static double getValueForLimit(Terminal t, LimitType type) {
        return LimitViolationUtils.getValueForLimit((Terminal)t, (LimitType)type);
    }
}

