/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.BusBreakerTopologyModel;
import com.powsybl.iidm.network.impl.ConfiguredBus;
import com.powsybl.iidm.network.impl.ConfiguredBusImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

class BusAdderImpl
extends AbstractIdentifiableAdder<BusAdderImpl>
implements BusAdder {
    private final VoltageLevelExt voltageLevel;

    BusAdderImpl(VoltageLevelExt voltageLevel) {
        this.voltageLevel = voltageLevel;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.voltageLevel.getNetwork();
    }

    @Override
    protected String getTypeDescription() {
        return "Bus";
    }

    public ConfiguredBus add() {
        String id = this.checkAndGetUniqueId();
        ConfiguredBusImpl bus = new ConfiguredBusImpl(id, this.getName(), this.isFictitious(), this.voltageLevel);
        ((BusBreakerTopologyModel)this.voltageLevel.getTopologyModel()).addBus(bus);
        this.getNetwork().getListeners().notifyCreation(bus);
        return bus;
    }
}

