/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationException;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.BusbarSectionImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.NodeTerminal;
import com.powsybl.iidm.network.impl.VoltageLevelExt;

class BusbarSectionAdderImpl
extends AbstractIdentifiableAdder<BusbarSectionAdderImpl>
implements BusbarSectionAdder {
    private final VoltageLevelExt voltageLevel;
    private Integer node;

    BusbarSectionAdderImpl(VoltageLevelExt voltageLevel) {
        this.voltageLevel = voltageLevel;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return this.voltageLevel.getNetwork();
    }

    @Override
    protected String getTypeDescription() {
        return "Busbar section";
    }

    public BusbarSectionAdder setNode(int node) {
        this.node = node;
        return this;
    }

    public BusbarSection add() {
        String id = this.checkAndGetUniqueId();
        if (this.node == null) {
            throw new ValidationException((Validable)this, "node is not set");
        }
        NodeTerminal terminal = new NodeTerminal(this.voltageLevel.getNetworkRef(), null, null, this.node);
        BusbarSectionImpl section = new BusbarSectionImpl(this.voltageLevel.getNetworkRef(), id, this.getName(), this.isFictitious());
        section.addTerminal(terminal);
        this.voltageLevel.getTopologyModel().attach(terminal, false);
        this.getNetwork().getIndex().checkAndAdd(section);
        this.getNetwork().getListeners().notifyCreation(section);
        return section;
    }
}

