/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TopologyVisitor;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.impl.AbstractBus;
import com.powsybl.iidm.network.impl.BusExt;
import com.powsybl.iidm.network.impl.CalculatedBus;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.NodeTerminal;
import com.powsybl.iidm.network.impl.TerminalExt;
import com.powsybl.iidm.network.impl.VoltageLevelExt;
import com.powsybl.iidm.network.util.Networks;
import gnu.trove.list.array.TIntArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

class CalculatedBusImpl
extends AbstractBus
implements CalculatedBus {
    private boolean valid = true;
    private final List<NodeTerminal> terminals;
    private final Function<Terminal, Bus> getBusFromTerminal;
    private NodeTerminal terminalRef;

    CalculatedBusImpl(String id, String name, boolean fictitious, VoltageLevelExt voltageLevel, TIntArrayList nodes, List<NodeTerminal> terminals, Function<Terminal, Bus> getBusFromTerminal) {
        super(id, name, fictitious, voltageLevel);
        this.terminals = Objects.requireNonNull(terminals);
        this.getBusFromTerminal = Objects.requireNonNull(getBusFromTerminal);
        this.terminalRef = CalculatedBusImpl.findTerminal(voltageLevel, nodes, terminals);
    }

    private static NodeTerminal findTerminal(VoltageLevelExt voltageLevel, TIntArrayList nodes, List<NodeTerminal> terminals) {
        if (!terminals.isEmpty()) {
            return terminals.get(0);
        }
        return (NodeTerminal)Networks.getEquivalentTerminal((VoltageLevel)voltageLevel, (int)nodes.getQuick(0));
    }

    private void checkValidity() {
        if (!this.valid) {
            throw new PowsyblException("Bus has been invalidated");
        }
    }

    @Override
    public void invalidate() {
        this.valid = false;
        this.voltageLevel = null;
        this.terminals.clear();
        this.terminalRef = null;
    }

    @Override
    public VoltageLevel getVoltageLevel() {
        this.checkValidity();
        return super.getVoltageLevel();
    }

    public int getConnectedTerminalCount() {
        this.checkValidity();
        return this.terminals.size();
    }

    public Collection<TerminalExt> getConnectedTerminals() {
        return this.getTerminals();
    }

    @Override
    public Stream<TerminalExt> getConnectedTerminalStream() {
        this.checkValidity();
        return this.terminals.stream().map(Function.identity());
    }

    public Collection<TerminalExt> getTerminals() {
        this.checkValidity();
        return Collections.unmodifiableCollection(this.terminals);
    }

    public BusExt setV(double v) {
        this.checkValidity();
        for (NodeTerminal terminal : this.terminals) {
            terminal.setV(v);
        }
        return this;
    }

    public double getV() {
        this.checkValidity();
        return this.terminalRef == null ? Double.NaN : this.terminalRef.getV();
    }

    public BusExt setAngle(double angle) {
        this.checkValidity();
        for (NodeTerminal terminal : this.terminals) {
            terminal.setAngle(angle);
        }
        return this;
    }

    public double getAngle() {
        this.checkValidity();
        return this.terminalRef == null ? Double.NaN : this.terminalRef.getAngle();
    }

    @Override
    public double getP() {
        this.checkValidity();
        return super.getP();
    }

    @Override
    public double getQ() {
        this.checkValidity();
        return super.getQ();
    }

    public double getFictitiousP0() {
        this.checkValidity();
        return Networks.getNodes((String)this.id, (VoltageLevel)this.voltageLevel, this.getBusFromTerminal).mapToDouble(n -> this.voltageLevel.getNodeBreakerView().getFictitiousP0(n)).reduce(0.0, Double::sum);
    }

    public Bus setFictitiousP0(double p0) {
        this.checkValidity();
        Networks.getNodes((String)this.id, (VoltageLevel)this.voltageLevel, this.getBusFromTerminal).forEach(n -> this.voltageLevel.getNodeBreakerView().setFictitiousP0(n, 0.0));
        this.voltageLevel.getNodeBreakerView().setFictitiousP0(Networks.getNodes((String)this.id, (VoltageLevel)this.voltageLevel, this.getBusFromTerminal).findFirst().orElseThrow(() -> new PowsyblException("Bus " + this.id + " should contain at least one node")), p0);
        return this;
    }

    public double getFictitiousQ0() {
        this.checkValidity();
        return Networks.getNodes((String)this.id, (VoltageLevel)this.voltageLevel, this.getBusFromTerminal).mapToDouble(n -> this.voltageLevel.getNodeBreakerView().getFictitiousQ0(n)).reduce(0.0, Double::sum);
    }

    public Bus setFictitiousQ0(double q0) {
        this.checkValidity();
        Networks.getNodes((String)this.id, (VoltageLevel)this.voltageLevel, this.getBusFromTerminal).forEach(n -> this.voltageLevel.getNodeBreakerView().setFictitiousQ0(n, 0.0));
        this.voltageLevel.getNodeBreakerView().setFictitiousQ0(Networks.getNodes((String)this.id, (VoltageLevel)this.voltageLevel, this.getBusFromTerminal).findFirst().orElseThrow(() -> new PowsyblException("Bus " + this.id + " should contain at least one node")), q0);
        return this;
    }

    @Override
    public void setConnectedComponentNumber(int connectedComponentNumber) {
        this.checkValidity();
        for (NodeTerminal terminal : this.terminals) {
            terminal.setConnectedComponentNumber(connectedComponentNumber);
        }
    }

    public Component getConnectedComponent() {
        this.checkValidity();
        NetworkImpl.ConnectedComponentsManager ccm = this.voltageLevel.getNetwork().getConnectedComponentsManager();
        ccm.update();
        return this.terminalRef == null ? null : ccm.getComponent(this.terminalRef.getConnectedComponentNumber());
    }

    @Override
    public void setSynchronousComponentNumber(int componentNumber) {
        this.checkValidity();
        for (NodeTerminal terminal : this.terminals) {
            terminal.setSynchronousComponentNumber(componentNumber);
        }
    }

    public Component getSynchronousComponent() {
        this.checkValidity();
        NetworkImpl.SynchronousComponentsManager scm = this.voltageLevel.getNetwork().getSynchronousComponentsManager();
        scm.update();
        return this.terminalRef == null ? null : scm.getComponent(this.terminalRef.getSynchronousComponentNumber());
    }

    @Override
    public Iterable<Line> getLines() {
        this.checkValidity();
        return super.getLines();
    }

    @Override
    public Stream<Line> getLineStream() {
        this.checkValidity();
        return super.getLineStream();
    }

    @Override
    public Iterable<TwoWindingsTransformer> getTwoWindingsTransformers() {
        this.checkValidity();
        return super.getTwoWindingsTransformers();
    }

    @Override
    public Stream<TwoWindingsTransformer> getTwoWindingsTransformerStream() {
        this.checkValidity();
        return super.getTwoWindingsTransformerStream();
    }

    @Override
    public Iterable<ThreeWindingsTransformer> getThreeWindingsTransformers() {
        this.checkValidity();
        return super.getThreeWindingsTransformers();
    }

    @Override
    public Stream<ThreeWindingsTransformer> getThreeWindingsTransformerStream() {
        this.checkValidity();
        return super.getThreeWindingsTransformerStream();
    }

    @Override
    public Iterable<Load> getLoads() {
        this.checkValidity();
        return super.getLoads();
    }

    @Override
    public Stream<Load> getLoadStream() {
        this.checkValidity();
        return super.getLoadStream();
    }

    @Override
    public Iterable<ShuntCompensator> getShuntCompensators() {
        this.checkValidity();
        return super.getShuntCompensators();
    }

    @Override
    public Stream<ShuntCompensator> getShuntCompensatorStream() {
        this.checkValidity();
        return super.getShuntCompensatorStream();
    }

    @Override
    public Iterable<Generator> getGenerators() {
        this.checkValidity();
        return super.getGenerators();
    }

    @Override
    public Stream<Generator> getGeneratorStream() {
        this.checkValidity();
        return super.getGeneratorStream();
    }

    @Override
    public Iterable<DanglingLine> getDanglingLines(DanglingLineFilter danglingLineFilter) {
        this.checkValidity();
        return super.getDanglingLines(danglingLineFilter);
    }

    @Override
    public Stream<DanglingLine> getDanglingLineStream(DanglingLineFilter danglingLineFilter) {
        this.checkValidity();
        return super.getDanglingLineStream(danglingLineFilter);
    }

    @Override
    public Iterable<StaticVarCompensator> getStaticVarCompensators() {
        this.checkValidity();
        return super.getStaticVarCompensators();
    }

    @Override
    public Stream<StaticVarCompensator> getStaticVarCompensatorStream() {
        this.checkValidity();
        return super.getStaticVarCompensatorStream();
    }

    @Override
    public Iterable<LccConverterStation> getLccConverterStations() {
        this.checkValidity();
        return super.getLccConverterStations();
    }

    @Override
    public Stream<LccConverterStation> getLccConverterStationStream() {
        this.checkValidity();
        return super.getLccConverterStationStream();
    }

    @Override
    public Iterable<VscConverterStation> getVscConverterStations() {
        this.checkValidity();
        return super.getVscConverterStations();
    }

    @Override
    public Stream<VscConverterStation> getVscConverterStationStream() {
        this.checkValidity();
        return super.getVscConverterStationStream();
    }

    @Override
    public void visitConnectedEquipments(TopologyVisitor visitor) {
        this.checkValidity();
        super.visitConnectedEquipments(visitor);
    }

    @Override
    public void visitConnectedOrConnectableEquipments(TopologyVisitor visitor) {
        this.checkValidity();
        super.visitConnectedOrConnectableEquipments(visitor);
    }
}

