/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.Component;
import com.powsybl.iidm.network.DcBus;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.DcTerminal;
import com.powsybl.iidm.network.DcTopologyVisitable;
import com.powsybl.iidm.network.DcTopologyVisitor;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.impl.AbstractDcTopologyVisitable;
import com.powsybl.iidm.network.impl.DcNodeImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class DcBusImpl
extends AbstractDcTopologyVisitable<DcBus>
implements DcBus {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private final Set<DcNodeImpl> dcNodes;
    private boolean valid = true;

    DcBusImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef, String id, String name, Set<DcNodeImpl> dcNodes) {
        super(id, name);
        this.networkRef = Objects.requireNonNull(ref);
        this.subnetworkRef = subnetworkRef;
        this.dcNodes = Objects.requireNonNull(dcNodes);
    }

    public double getV() {
        this.checkValidity();
        for (DcNode dcNode : this.dcNodes) {
            if (Double.isNaN(dcNode.getV())) continue;
            return dcNode.getV();
        }
        return Double.NaN;
    }

    public DcBus setV(double v) {
        this.checkValidity();
        for (DcNode dcNode : this.dcNodes) {
            dcNode.setV(v);
        }
        return this;
    }

    void setConnectedComponentNumber(int connectedComponentNumber) {
        this.checkValidity();
        for (DcNodeImpl dcNode : this.dcNodes) {
            dcNode.setConnectedComponentNumber(connectedComponentNumber);
        }
    }

    void setDcComponentNumber(int dcComponentNumber) {
        this.checkValidity();
        for (DcNodeImpl dcNode : this.dcNodes) {
            dcNode.setDcComponentNumber(dcComponentNumber);
        }
    }

    public Component getConnectedComponent() {
        this.checkValidity();
        for (DcNodeImpl dcNode : this.dcNodes) {
            Component cc = dcNode.getConnectedComponent();
            if (cc == null) continue;
            return cc;
        }
        throw new IllegalStateException("Should not happen");
    }

    public boolean isInMainConnectedComponent() {
        Component cc = this.getConnectedComponent();
        return cc != null && cc.getNum() == 0;
    }

    public Component getDcComponent() {
        this.checkValidity();
        for (DcNodeImpl dcNode : this.dcNodes) {
            Component dcc = dcNode.getDcComponent();
            if (dcc == null) continue;
            return dcc;
        }
        throw new IllegalStateException("Should not happen");
    }

    public Iterable<DcNode> getDcNodes() {
        this.checkValidity();
        return Collections.unmodifiableCollection(this.dcNodes);
    }

    public Stream<DcNode> getDcNodeStream() {
        this.checkValidity();
        return this.dcNodes.stream().map(Function.identity());
    }

    public int getDcTerminalCount() {
        this.checkValidity();
        return this.dcNodes.stream().mapToInt(DcTopologyVisitable::getDcTerminalCount).sum();
    }

    public List<DcTerminal> getDcTerminals() {
        this.checkValidity();
        return this.getDcTerminalStream().toList();
    }

    public Stream<DcTerminal> getDcTerminalStream() {
        this.checkValidity();
        return this.dcNodes.stream().flatMap(DcTopologyVisitable::getDcTerminalStream);
    }

    public int getConnectedDcTerminalCount() {
        this.checkValidity();
        return this.dcNodes.stream().mapToInt(DcTopologyVisitable::getConnectedDcTerminalCount).sum();
    }

    @Override
    public List<DcTerminal> getConnectedDcTerminals() {
        this.checkValidity();
        return this.getConnectedDcTerminalStream().toList();
    }

    @Override
    public Stream<DcTerminal> getConnectedDcTerminalStream() {
        this.checkValidity();
        return this.dcNodes.stream().flatMap(DcTopologyVisitable::getConnectedDcTerminalStream);
    }

    public void visitConnectedEquipments(DcTopologyVisitor visitor) {
        this.checkValidity();
        for (DcNode dcNode : this.dcNodes) {
            dcNode.visitConnectedEquipments(visitor);
        }
    }

    public void visitConnectedOrConnectableEquipments(DcTopologyVisitor visitor) {
        this.checkValidity();
        for (DcNode dcNode : this.dcNodes) {
            dcNode.visitConnectedOrConnectableEquipments(visitor);
        }
    }

    public Network getParentNetwork() {
        return Optional.ofNullable((Network)this.subnetworkRef.get()).orElse(this.getNetwork());
    }

    @Override
    public NetworkImpl getNetwork() {
        return (NetworkImpl)this.networkRef.get();
    }

    @Override
    protected String getTypeDescription() {
        return "DC Bus";
    }

    void invalidate() {
        this.valid = false;
        this.dcNodes.clear();
    }

    private void checkValidity() {
        if (!this.valid) {
            throw new PowsyblException("DcBus has been invalidated");
        }
    }
}

