/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.DcGround;
import com.powsybl.iidm.network.DcGroundAdder;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.DcGroundImpl;
import com.powsybl.iidm.network.impl.DcTerminalImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import java.util.Objects;
import java.util.Optional;

public class DcGroundAdderImpl
extends AbstractIdentifiableAdder<DcGroundAdderImpl>
implements DcGroundAdder {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private double r = 0.0;
    private String dcNodeId;
    private boolean connected = true;

    DcGroundAdderImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef) {
        this.networkRef = ref;
        this.subnetworkRef = subnetworkRef;
    }

    public DcGroundAdder setR(double r) {
        this.r = r;
        return this;
    }

    public DcGroundAdder setDcNode(String dcNode) {
        this.dcNodeId = Objects.requireNonNull(dcNode);
        return this;
    }

    public DcGroundAdder setConnected(boolean connected) {
        this.connected = connected;
        return this;
    }

    public DcGround add() {
        String id = this.checkAndGetUniqueId();
        DcNode dcNode = ValidationUtil.checkAndGetDcNode((Network)this.getNetwork().getParentNetwork(), (Validable)this, (String)this.dcNodeId, (String)"dcNode");
        ValidationUtil.checkSameParentNetwork((Network)this.getParentNetwork(), (Validable)this, (DcNode)dcNode);
        ValidationUtil.checkDoubleParamPositive((Validable)this, (double)this.r, (String)"r");
        DcGroundImpl dcGround = new DcGroundImpl(this.networkRef, this.subnetworkRef, id, this.getName(), this.isFictitious(), this.r);
        DcTerminalImpl dcTerminal = new DcTerminalImpl(this.networkRef, null, null, dcNode, this.connected);
        dcGround.addDcTerminal(dcTerminal);
        ((AbstractNetwork)this.getParentNetwork()).getDcTopologyModel().attach(dcTerminal);
        this.getNetwork().getIndex().checkAndAdd(dcGround);
        this.getNetwork().getListeners().notifyCreation(dcGround);
        return dcGround;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return (NetworkImpl)this.networkRef.get();
    }

    private Network getParentNetwork() {
        return Optional.ofNullable((Network)this.subnetworkRef.get()).orElse(this.getNetwork());
    }

    @Override
    protected String getTypeDescription() {
        return "DC Ground";
    }
}

