/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.DcGround;
import com.powsybl.iidm.network.DcTerminal;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractDcConnectable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;

public class DcGroundImpl
extends AbstractDcConnectable<DcGround>
implements DcGround {
    public static final String R_ATTRIBUTE = "r";
    private double r;

    DcGroundImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef, String id, String name, boolean fictitious, double r) {
        super(ref, subnetworkRef, id, name, fictitious);
        this.r = r;
    }

    @Override
    protected String getTypeDescription() {
        return "DC Ground";
    }

    public DcTerminal getDcTerminal() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"terminal");
        return (DcTerminal)this.dcTerminals.get(0);
    }

    public double getR() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)R_ATTRIBUTE);
        return this.r;
    }

    public DcGround setR(double r) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)R_ATTRIBUTE);
        ValidationUtil.checkDoubleParamPositive((Validable)this, (double)r, (String)R_ATTRIBUTE);
        double oldValue = this.r;
        this.r = r;
        this.getNetwork().getListeners().notifyUpdate(this, R_ATTRIBUTE, (Object)oldValue, (Object)r);
        return this;
    }
}

