/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.DcLine;
import com.powsybl.iidm.network.DcLineAdder;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.DcLineImpl;
import com.powsybl.iidm.network.impl.DcTerminalImpl;
import com.powsybl.iidm.network.impl.DcTopologyModel;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import java.util.Objects;
import java.util.Optional;

public class DcLineAdderImpl
extends AbstractIdentifiableAdder<DcLineAdderImpl>
implements DcLineAdder {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private double r = Double.NaN;
    private String dcNode1Id;
    private boolean connected1 = true;
    private String dcNode2Id;
    private boolean connected2 = true;

    DcLineAdderImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef) {
        this.networkRef = ref;
        this.subnetworkRef = subnetworkRef;
    }

    public DcLineAdder setR(double r) {
        this.r = r;
        return this;
    }

    public DcLineAdder setDcNode1(String dcNode1) {
        this.dcNode1Id = Objects.requireNonNull(dcNode1);
        return this;
    }

    public DcLineAdder setConnected1(boolean connected1) {
        this.connected1 = connected1;
        return this;
    }

    public DcLineAdder setDcNode2(String dcNode2) {
        this.dcNode2Id = Objects.requireNonNull(dcNode2);
        return this;
    }

    public DcLineAdder setConnected2(boolean connected2) {
        this.connected2 = connected2;
        return this;
    }

    public DcLine add() {
        String id = this.checkAndGetUniqueId();
        DcNode dcNode1 = ValidationUtil.checkAndGetDcNode((Network)this.getNetwork().getParentNetwork(), (Validable)this, (String)this.dcNode1Id, (String)"dcNode1");
        DcNode dcNode2 = ValidationUtil.checkAndGetDcNode((Network)this.getNetwork().getParentNetwork(), (Validable)this, (String)this.dcNode2Id, (String)"dcNode2");
        ValidationUtil.checkSameParentNetwork((Network)this.getParentNetwork(), (Validable)this, (DcNode)dcNode1, (DcNode)dcNode2);
        ValidationUtil.checkDoubleParamPositive((Validable)this, (double)this.r, (String)"r");
        DcLineImpl dcLine = new DcLineImpl(this.networkRef, this.subnetworkRef, id, this.getName(), this.isFictitious(), this.r);
        DcTerminalImpl dcTerminal1 = new DcTerminalImpl(this.networkRef, TwoSides.ONE, null, dcNode1, this.connected1);
        DcTerminalImpl dcTerminal2 = new DcTerminalImpl(this.networkRef, TwoSides.TWO, null, dcNode2, this.connected2);
        dcLine.addDcTerminal(dcTerminal1);
        dcLine.addDcTerminal(dcTerminal2);
        DcTopologyModel dcTopologyModel = ((AbstractNetwork)this.getParentNetwork()).getDcTopologyModel();
        dcTopologyModel.attach(dcTerminal1);
        dcTopologyModel.attach(dcTerminal2);
        this.getNetwork().getIndex().checkAndAdd(dcLine);
        this.getNetwork().getListeners().notifyCreation(dcLine);
        return dcLine;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return (NetworkImpl)this.networkRef.get();
    }

    private Network getParentNetwork() {
        return Optional.ofNullable((Network)this.subnetworkRef.get()).orElse(this.getNetwork());
    }

    @Override
    protected String getTypeDescription() {
        return "DC Line";
    }
}

