/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.DcLine;
import com.powsybl.iidm.network.DcTerminal;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractDcConnectable;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import java.util.Objects;

public class DcLineImpl
extends AbstractDcConnectable<DcLine>
implements DcLine {
    public static final String R_ATTRIBUTE = "r";
    private double r;

    DcLineImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef, String id, String name, boolean fictitious, double r) {
        super(ref, subnetworkRef, id, name, fictitious);
        this.r = r;
    }

    @Override
    protected String getTypeDescription() {
        return "DC Line";
    }

    public DcTerminal getDcTerminal1() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"terminal1");
        return (DcTerminal)this.dcTerminals.get(0);
    }

    public DcTerminal getDcTerminal2() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"terminal2");
        return (DcTerminal)this.dcTerminals.get(1);
    }

    public DcTerminal getDcTerminal(TwoSides side) {
        Objects.requireNonNull(side);
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)"terminal");
        if (side == TwoSides.ONE) {
            return (DcTerminal)this.dcTerminals.get(0);
        }
        if (side == TwoSides.TWO) {
            return (DcTerminal)this.dcTerminals.get(1);
        }
        throw new IllegalStateException("Unexpected side: " + String.valueOf(side));
    }

    public TwoSides getSide(DcTerminal dcTerminal) {
        Objects.requireNonNull(dcTerminal);
        if (this.getDcTerminal1() == dcTerminal) {
            return TwoSides.ONE;
        }
        if (this.getDcTerminal2() == dcTerminal) {
            return TwoSides.TWO;
        }
        throw new IllegalStateException("The DC terminal is not connected to this DC line");
    }

    public double getR() {
        ValidationUtil.checkAccessOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)R_ATTRIBUTE);
        return this.r;
    }

    public DcLine setR(double r) {
        ValidationUtil.checkModifyOfRemovedEquipment((String)this.id, (boolean)this.removed, (String)R_ATTRIBUTE);
        ValidationUtil.checkDoubleParamPositive((Validable)this, (double)r, (String)R_ATTRIBUTE);
        double oldValue = this.r;
        this.r = r;
        this.getNetwork().getListeners().notifyUpdate(this, R_ATTRIBUTE, (Object)oldValue, (Object)r);
        return this;
    }
}

