/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.impl;

import com.powsybl.commons.ref.Ref;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.DcNodeAdder;
import com.powsybl.iidm.network.Validable;
import com.powsybl.iidm.network.ValidationUtil;
import com.powsybl.iidm.network.impl.AbstractIdentifiableAdder;
import com.powsybl.iidm.network.impl.AbstractNetwork;
import com.powsybl.iidm.network.impl.DcNodeImpl;
import com.powsybl.iidm.network.impl.NetworkImpl;
import com.powsybl.iidm.network.impl.SubnetworkImpl;
import java.util.Optional;

public class DcNodeAdderImpl
extends AbstractIdentifiableAdder<DcNodeAdderImpl>
implements DcNodeAdder {
    private final Ref<NetworkImpl> networkRef;
    private final Ref<SubnetworkImpl> subnetworkRef;
    private double nominalV = Double.NaN;

    DcNodeAdderImpl(Ref<NetworkImpl> ref, Ref<SubnetworkImpl> subnetworkRef) {
        this.networkRef = ref;
        this.subnetworkRef = subnetworkRef;
    }

    public DcNodeAdder setNominalV(double nominalV) {
        this.nominalV = nominalV;
        return this;
    }

    public DcNode add() {
        String id = this.checkAndGetUniqueId();
        ValidationUtil.checkNominalV((Validable)this, (double)this.nominalV);
        DcNodeImpl dcNode = new DcNodeImpl(this.networkRef, this.subnetworkRef, id, this.getName(), this.isFictitious(), this.nominalV);
        NetworkImpl network = (NetworkImpl)this.networkRef.get();
        network.getIndex().checkAndAdd(dcNode);
        network.getListeners().notifyCreation(dcNode);
        this.getParentNetwork().getDcTopologyModel().addDcNodeToTopology(dcNode);
        return dcNode;
    }

    @Override
    protected NetworkImpl getNetwork() {
        return (NetworkImpl)this.networkRef.get();
    }

    @Override
    protected String getTypeDescription() {
        return "DC Node";
    }

    private AbstractNetwork getParentNetwork() {
        return Optional.ofNullable((AbstractNetwork)this.subnetworkRef.get()).orElse(this.getNetwork());
    }
}

